/*
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 2 of
 *  the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details:
 *
 *  http://www.gnu.org/copyleft/gpl.txt
 */

#include "shared.h"

/* Runtime config data */
rc_data_t rc_data;

/* Global widgets */
GtkWidget
  *sdrx_main_window   = NULL,
  *spectrum_window    = NULL,
  *stations_window	  = NULL,
  *time_window		  = NULL,
  *smeter_drawingarea = NULL,
  *smeter_progbar     = NULL,
  *signal_display     = NULL,
  *spectrum_display   = NULL,
  *center_freq_entry  = NULL,
  *freq_offset_label  = NULL,
  *afc_checkbutton	  = NULL,
  *fft_bw_combobox    = NULL,
  *demod_bw_combobox  = NULL,
  *smp_rate_combobox  = NULL,
  *sdrx_buf_combobox  = NULL,
  *weaver_combobox    = NULL;

/* Tree list store and treeview for stations window */
GtkListStore *stations_list_store = NULL;
GtkTreeView  *stations_treeview   = NULL;

/* Spectrum window pixbuf */
GdkPixbuf *spectrum_pixbuf = NULL;
guchar    *spectrum_pixels = NULL;

/* Signal window pixbuf */
GdkPixmap *signal_pixmap = NULL;

/* Common between callbacks.c
 * and callback_func.c */
GtkWidget
  *quit_dialog  = NULL,
  *error_dialog = NULL;

/* fft input buffers */
double
  *fft_in_i = NULL,
  *fft_in_q = NULL;

/* Playback Ring Buffer */
short **playback_buf = NULL;
int sound_buf_num = 0;
int demod_buf_num = 0;

/* Sdrx Samples Buffer */
double *sdrx_buf_i = NULL;
double *sdrx_buf_q = NULL;

/* Playback and buffer control semaphore */
sem_t pback_semaphore;
sem_t newbuf_semaphore;

/* Filter data for the main roofing filter */
filter_data_t fft_filter_data_i;
filter_data_t fft_filter_data_q;

/*----------------------------------------------------------------------*/

