/*
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 2 of
 *  the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details:
 *
 *  http://www.gnu.org/copyleft/gpl.txt
 */

#ifndef SDRPLAY_H
#define SDRPLAY_H		1

#include "common.h"
#include "demodulate.h"
#include "utils.h"

/* Decimation control */
#define USE_AVERAGING	0
#define USE_HALF_BAND	1
#define DECIMATE_2		2
#define DECIMATE_4		4
#define DECIMATE_8		8
#define DECIMATE_16		16
#define DECIMATE_32		32
#define DECIMATE_64		64
#define MIN_SMPL_RATE	2000000

/* Agc/freq etc Update Control */
#define IMMEDIATE		0
#define SYNCHRONOUS		1

/* DC offset correction mode */
#define STATIC		0
#define PERIODIC_1	1 // Correction applied periodically every 6mS
#define PERIODIC_2	2 // Correction applied periodically every 12mS
#define PERIODIC_3	3 // Correction applied periodically every 24mS
#define ONE_SHOT	4 // correction applied each time gain update performed
#define CONTINUOUS	5

/* Frequency ranges in Hz
 * of the SDRPlay RF front end */
#define FREQUENCY_RANGES \
  10000,      \
  12000000,   \
  30000000,   \
  60000000,   \
  120000000,  \
  250000000,  \
  420000000,  \
  1000000000, \
  2000000000

#define NUM_FREQ_RANGES		9
#define OFFSET_MODE			0
#define ABSOLUTE_MODE		1

#define SDRPLAY_GAIN_AUTO	1
#define SDRPLAY_GAIN_MANL	0

/* Max gain reduction to pass to AGC control */
#define	SDRPLAY_MAX_GRDB	100.0

#endif

