/*
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 2 of
 *  the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details:
 *
 *  http://www.gnu.org/copyleft/gpl.txt
 */

#ifndef MONITORS_H
#define MONITORS_H		1

#include "common.h"
#include "demodulate.h"

/* +/- Range in FFT bins to search for FFT max to click-tune */
#define CLICK_TUNE_RANGE	20

/* Scale factors to avoid overflow in fft summations */
#define RTLSDR_FFT_SCALE	1.0
#define SDRPLAY_FFT_SCALE	128.0
#define PERSEUS_FFT_SCALE	8192.0

/* Length of input/output buffers for FFT */
#define FFT_INPUT_LENGTH	1024

/* Cairo RGB values for colors in plotting */
#define SIGNAL_BACKGND		0.0, 0.2, 0.0
#define SIGNAL_DEMODBW		0.0, 0.3, 0.3
#define SIGNAL_TRACES		0.0, 1.0, 0.0
#define SIGNAL_RETICLE		0.7, 0.5, 0.0
#define SIGNAL_SCALES		1.0, 0.9, 0.0
#define SIGNAL_CENTERLINE	0.0, 1.0, 1.0

/* Max number of steps in Frequency scale */
#define MAX_FREQ_SCALE_STEPS	18

/* Number of steps in the Level scale */
#define NUM_LEVEL_STEPS		8
#define LEVEL_STEP			10

#endif

