/*
 * Initial main.c file generated by Glade. Edit as required.
 * Glade will not overwrite this file.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include "main.h"
#include "shared.h"

/* Signal handler */
static void sig_handler( int signal );

  int
main (int argc, char *argv[])
{
  /* New and old actions for sigaction() */
  struct sigaction sa_new, sa_old;

  /* Initialize new actions */
  sa_new.sa_handler = sig_handler;
  sigemptyset( &sa_new.sa_mask );
  sa_new.sa_flags = 0;

  /* Register function to handle signals */
  sigaction( SIGINT,  &sa_new, &sa_old );
  sigaction( SIGSEGV, &sa_new, 0 );
  sigaction( SIGFPE,  &sa_new, 0 );
  sigaction( SIGTERM, &sa_new, 0 );
  sigaction( SIGABRT, &sa_new, 0 );

#ifdef ENABLE_NLS
  bindtextdomain (GETTEXT_PACKAGE, PACKAGE_LOCALE_DIR);
  bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
  textdomain (GETTEXT_PACKAGE);
#endif

  gtk_set_locale ();
  gtk_init (&argc, &argv);

  add_pixmap_directory (PACKAGE_DATA_DIR "/" PACKAGE "/pixmaps");

  /*
   * The following code was added by Glade to create one of each component
   * (except popup menus), just so that you see something after building
   * the project. Delete any components that you don't want shown initially.
   */
  sdrx_main_window = create_main_window ();
  gtk_window_set_title( GTK_WINDOW(sdrx_main_window), PACKAGE_STRING );
  gtk_widget_show (sdrx_main_window);

  /* Get the widgets of main window */
  smeter_progbar     = lookup_widget( sdrx_main_window, "smeter_progressbar" );
  center_freq_entry  = lookup_widget( sdrx_main_window, "center_freq_entry" );
  gtk_entry_set_alignment( GTK_ENTRY(center_freq_entry), 1.0 );
  freq_offset_label  = lookup_widget( sdrx_main_window, "freq_offset_label" );
  afc_checkbutton	 = lookup_widget( sdrx_main_window, "afc_checkbutton" );
  fft_bw_combobox	 = lookup_widget( sdrx_main_window, "fft_bw_combobox" );
  demod_bw_combobox  = lookup_widget( sdrx_main_window, "demod_bw_combobox" );
  smp_rate_combobox  = lookup_widget( sdrx_main_window, "smp_rate_combobox" );
  sdrx_buf_combobox  = lookup_widget( sdrx_main_window, "sdrx_buf_combobox" );
  weaver_combobox    = lookup_widget( sdrx_main_window, "weaver_combobox" );

  rc_data.playback_buffs = 0;

  /* Load the rc_config file */
  g_idle_add( Load_Config, NULL );

  gtk_main ();
  return 0;
}

/*----------------------------------------------------------------------*/

/*  sig_handler()
 *
 *  Signal Action Handler function
 */

  static void
sig_handler( int signal )
{
  Sdrx_Stop();

  fprintf( stderr, "\n" );
  switch( signal )
  {
	case SIGINT :
	  fprintf( stderr, "%s\n", _("sdrx: Exiting via User Interrupt") );
	  exit(-1);

	case SIGSEGV :
	  fprintf( stderr, "%s\n", _("sdrx: Segmentation Fault") );
	  exit(-1);

	case SIGFPE :
	  fprintf( stderr, "%s\n", _("sdrx: Floating Point Exception") );
	  exit(-1);

	case SIGABRT :
	  fprintf( stderr, "%s\n", _("sdrx: Abort Signal received") );
	  exit(-1);

	case SIGTERM :
	  fprintf( stderr, "%s\n", _("sdrx: Termination Request received") );
	  exit(-1);
  }

} /* End of sig_handler() */

/*----------------------------------------------------------------------*/

