/*
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 2 of
 *  the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details:
 *
 *  http://www.gnu.org/copyleft/gpl.txt
 */

#ifndef FILTERS_H
#define FILTERS_H		1

#include "common.h"

/* Low Pass Filter parameters for main rtlsdr
 * filter. The number of poles _must_ be even */
#define ROOFING_FILTER_POLES		6
#define ROOFING_FILTER_RIPPLE		10.0

/* Low Pass Filter parameters for CW/SSB/AM demodulator
 * filters. The number of poles _must_ be even */
#define FM_FILTER_POLES		6
#define FM_FILTER_RIPPLE	10.0
#define AM_FILTER_POLES		6
#define AM_FILTER_RIPPLE	10.0
#define SSB_FILTER_POLES	8
#define SSB_FILTER_RIPPLE	10.0
#define CW_FILTER_POLES		6
#define CW_FILTER_RIPPLE	10.0

/* Low Pass Filter parameters for the AFC in SSB/Sync-AM
 * demod. The number of poles _must_ be even */
#define AFC_FILTER_POLES	4
#define AFC_FILTER_RIPPLE	10.0

#endif

