/*
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 2 of
 *  the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details:
 *
 *  http://www.gnu.org/copyleft/gpl.txt
 */

#ifndef DEMODULATE_H
#define DEMODULATE_H	1

#include "common.h"
#include "filters.h"
#include "monitors.h"
#include "sound.h"
#include "callback_func.h"

/* Max AFC correction range in Hz */
#define MAX_FREQUENCY_OFFSET	2000.0

/* AFC filter bandwidth in SSB/AM-SYNC mode */
#define AFC_BANDWIDTH	1000.0

/* Length and multiplier for AM averaging window */
#define AM_AVE_WINDOW_LEN		5000.0
#define AM_AVE_WINDOW_MUL		4999.0   /* above -1 always */

/* Noise Squelch parameters */
#define SQUELCH_WINDOW_LEN		1000.0
#define SQUELCH_WINDOW_MULT		999.0   /* above -1 always */
#define SQUELCH_THRESHOLD		300.0

/* Audio AGC reference Audio level */
#define ADAGC_REF_LEVEL		25000.0

/* S-meter range in dBm (0 to -150 dBm) */
#define SMETER_RANGE_DBM	150.0

/* Perseus S-meter offset to raise ADAGC dBm range to -150 - 0 dBm */
#define PERSEUS_SMETER_OFFSET	45.0

#endif

