#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>

#include "callbacks.h"
#include "interface.h"
#include "support.h"
#include "callback_func.h"
#include "common.h"
#include "perseus.h"
#include "rtlsdr.h"
#include "shared.h"
#include "utils.h"


void
on_main_window_destroy                 (GtkObject       *object,
                                        gpointer         user_data)
{
  Sdrx_Stop();
  gtk_main_quit();
}


gboolean
on_main_window_delete_event            (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
  quit_dialog = create_quit_dialog();
  gtk_widget_show( quit_dialog );
  return TRUE;
}


gboolean
on_freq_scroll_event                   (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
  gboolean ret = Frequency_Scroll_Event( widget, event );
  return( ret );
}


gboolean
on_freq_button_press_event             (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
  gboolean ret = Frequency_Button_Press_Event( widget, event );
  return( ret );
}


void
on_center_freq_entry_activate          (GtkEntry        *entry,
                                        gpointer         user_data)
{
  /* Get center freq value in Hz, entry value is in kHz */
  double khz = atof( gtk_entry_get_text(entry) );
  rc_data.sdrx_center_freq = (uint32_t)( khz * 1000.0 );
  if( rc_data.sdrx_center_freq < 1 )
	rc_data.sdrx_center_freq = 1;
  Sdrx_Set_Center_Frequency( rc_data.sdrx_center_freq );
}


gboolean
on_center_freq_entry_scroll_event      (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
  int center_freq = (int)rc_data.sdrx_center_freq;
  if( event->scroll.direction == GDK_SCROLL_UP )
	center_freq += 1000;
  else if( event->scroll.direction == GDK_SCROLL_DOWN )
	center_freq -= 1000;
  if( center_freq < 0 ) center_freq = 0;
  Sdrx_Set_Center_Frequency( rc_data.sdrx_center_freq );
  return TRUE;
}


void
on_afc_checkbutton_toggled             (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
  if( gtk_toggle_button_get_active(togglebutton) )
	SetFlag( ENABLE_FREQ_CORR );
  else
	ClearFlag( ENABLE_FREQ_CORR );
}


void
on_menu_button_clicked                 (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget *modes_menu = create_modes_menu();
  gtk_menu_popup( GTK_MENU(modes_menu), NULL, NULL, NULL, NULL, 0, 0 );
}


void
on_weaver_combobox_changed             (GtkComboBox     *combobox,
                                        gpointer         user_data)
{
  Weaver_Combobox_Changed( combobox );
}


void
on_demod_bw_combobox_changed           (GtkComboBox     *combobox,
                                        gpointer         user_data)
{
  Demodulator_Bandwidth_Combobox_Changed( combobox );
}


void
on_smp_rate_combobox_changed           (GtkComboBox     *combobox,
                                        gpointer         user_data)
{
  Rate_Combobox_Changed( combobox );
}


void
on_sdrx_buf_combobox_changed           (GtkComboBox     *combobox,
                                        gpointer         user_data)
{
  /* Reset and reallocate async buffer */
  Sdrx_Change_Buffer( combobox );
}


void
on_fft_bw_combobox_changed             (GtkComboBox     *combobox,
                                        gpointer         user_data)
{
  FFT_Bandwidth_Changed( (void *)combobox );
}


void
on_gain_hscale_value_changed           (GtkRange        *range,
                                        gpointer         user_data)
{
  if( isFlagClear(SDRX_INITIALIZED) ||
	  isFlagSet(TUNER_GAIN_AUTO)    ||
	  isFlagSet(TUNER_GAIN_ADAGC) )
	return;

  double gain = gtk_range_get_value( range );
  Sdrx_Set_Tuner_Gain( gain );
}


void
on_man_agc_radiobtn_toggled            (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
  if( isFlagClear(SDRX_INITIALIZED) )
	return;

  if( gtk_toggle_button_get_active(togglebutton) )
  {
	GtkWidget *hscale = lookup_widget( sdrx_main_window, "gain_hscale");
	gtk_range_set_value( GTK_RANGE(hscale), rc_data.tuner_gain );
	ClearFlag( TUNER_GAIN_AUTO );
	ClearFlag( TUNER_GAIN_ADAGC );
	SetFlag(   TUNER_GAIN_MANUAL );
	Sdrx_Set_Tuner_Gain_Mode( TUNER_GAIN_MANUAL );
  }
}


void
on_auto_agc_radiobtn_toggled           (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
  if( isFlagClear(SDRX_INITIALIZED) )
	return;

  if( gtk_toggle_button_get_active(togglebutton) )
  {
	GtkWidget *hscale = lookup_widget( sdrx_main_window, "gain_hscale");
	gtk_range_set_value( GTK_RANGE(hscale), 0.0 );
	ClearFlag( TUNER_GAIN_MANUAL );
	ClearFlag( TUNER_GAIN_ADAGC );
	SetFlag(   TUNER_GAIN_AUTO );
	Sdrx_Set_Tuner_Gain_Mode( TUNER_GAIN_AUTO );
	rc_data.adagc_scale = 1.0;
  }
}


void
on_audio_agc_radiobtn_toggled          (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
  if( isFlagClear(SDRX_INITIALIZED) )
	return;

  if( gtk_toggle_button_get_active(togglebutton) )
  {
	GtkWidget *hscale = lookup_widget( sdrx_main_window, "gain_hscale");
	gtk_range_set_value( GTK_RANGE(hscale), 0.0 );
	ClearFlag( TUNER_GAIN_AUTO );
	ClearFlag( TUNER_GAIN_MANUAL );
	SetFlag(   TUNER_GAIN_ADAGC );
	Sdrx_Set_Tuner_Gain_Mode( TUNER_GAIN_ADAGC );
	rc_data.adagc_scale = 10.0;
  }
}


void
on_agc_hscale_value_changed            (GtkRange        *range,
                                        gpointer         user_data)
{
  /* Range is 10-100 and the formula below was derived
   * by trial and error to give a good compromise in
   * ADAGC attack/decay characteristics */
  gdouble val = gtk_range_get_value( range );
  rc_data.adagc_decay = 1.0 - val / ADAGC_DIVISOR;
}


void
on_squelch_hscale_value_changed        (GtkRange        *range,
                                        gpointer         user_data)
{
  rc_data.squelch_value  = SQUELCH_THRESHOLD * SQUELCH_RANGE;
  rc_data.squelch_value -= SQUELCH_THRESHOLD * gtk_range_get_value( range );
}


void
on_preamp_checkbutton_toggled          (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
  if( gtk_toggle_button_get_active(togglebutton) )
	Perseus_Settings( PERSEUS_ADC_PREAMP );
  else
	Perseus_Settings( ~PERSEUS_ADC_PREAMP );
}


void
on_preselect_checkbutton_toggled       (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
  if( gtk_toggle_button_get_active(togglebutton) )
	SetFlag(PRESELECT_ENABLE);
  else
	ClearFlag(PRESELECT_ENABLE);
  Sdrx_Set_Center_Frequency( rc_data.sdrx_center_freq );
}


void
on_att_10db_checkbutton_toggled        (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
  if( gtk_toggle_button_get_active(togglebutton) )
  {
	Perseus_Settings(PERSEUS_ATTEN_10DB);
	gtk_toggle_button_set_active( GTK_TOGGLE_BUTTON(
		  lookup_widget(sdrx_main_window, "att_auto_checkbutton")), FALSE );
  }
  else
	Perseus_Settings(~PERSEUS_ATTEN_10DB);
}


void
on_att_20db_checkbutton_toggled        (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
  if( gtk_toggle_button_get_active(togglebutton) )
  {
	Perseus_Settings(PERSEUS_ATTEN_20DB);
	gtk_toggle_button_set_active( GTK_TOGGLE_BUTTON(
		  lookup_widget(sdrx_main_window, "att_auto_checkbutton")), FALSE );
  }
  else
	Perseus_Settings(~PERSEUS_ATTEN_20DB);
}


void
on_att_auto_checkbutton_toggled        (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
  if( gtk_toggle_button_get_active(togglebutton) )
  {
	SetFlag( PERSEUS_ATTEN_AUTO );
	gtk_toggle_button_set_active( GTK_TOGGLE_BUTTON(
		  lookup_widget(sdrx_main_window, "att_10db_checkbutton")), FALSE );
	gtk_toggle_button_set_active( GTK_TOGGLE_BUTTON(
		  lookup_widget(sdrx_main_window, "att_20db_checkbutton")), FALSE );
  }
  else
	ClearFlag( PERSEUS_ATTEN_AUTO );
}


void
on_time_button_clicked                 (GtkButton       *button,
                                        gpointer         user_data)
{
  /* Open time display window */
  if( time_window == NULL )
  {
	time_window = create_time_window();
	gtk_widget_show( time_window );
	GtkWidget *combo = lookup_widget(
		time_window, "time_station_combobox" );
	gtk_combo_box_set_active( GTK_COMBO_BOX(combo), 0 );
  }
}


void
on_stations_button_clicked             (GtkButton       *button,
                                        gpointer         user_data)
{
  if( stations_window == NULL )
  {
	stations_window = create_stations_window();
	gtk_widget_show( stations_window );
	List_Stations();
  }
}


void
on_spectrum_togglebutton_toggled       (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
  g_idle_add( Spectrum_Button_Toggled, (gpointer)togglebutton );
}


void
on_playback_togglebutton_toggled       (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
  g_idle_add( Playback_Button_Toggled, (gpointer)togglebutton );
}


gboolean
on_error_dialog_delete_event           (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
  return TRUE;
}


void
on_error_dialog_destroy                (GtkObject       *object,
                                        gpointer         user_data)
{
  error_dialog = NULL;
}


void
on_error_ok_button_clicked             (GtkButton       *button,
                                        gpointer         user_data)
{
  gtk_widget_destroy( error_dialog );
}


void
on_error_quit_button_clicked           (GtkButton       *button,
                                        gpointer         user_data)
{
  Sdrx_Stop();
  gtk_main_quit();
}


void
on_quit_cancel_button_clicked          (GtkButton       *button,
                                        gpointer         user_data)
{
  gtk_widget_destroy( quit_dialog );
}


void
on_quit_button_clicked                 (GtkButton       *button,
                                        gpointer         user_data)
{
  Sdrx_Stop();
  gtk_main_quit();
}


void
on_stations_window_destroy             (GtkObject       *object,
                                        gpointer         user_data)
{
  Save_Stations_File();
  stations_list_store = NULL;
  stations_treeview   = NULL;
  stations_window     = NULL;
}


void
on_stations_treeview_cursor_changed    (GtkTreeView     *treeview,
                                        gpointer         user_data)
{
  Stations_Cursor_Changed( treeview );
}


gboolean
on_stations_treeview_button_press_event
                                        (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
  if( event->button == 2 )
  {
	Treeview_Button_Press();
	return TRUE;
  }
  return FALSE;
}


void
on_down_button_clicked                 (GtkButton       *button,
                                        gpointer         user_data)
{
  Select_Treeview_Row( SELECT_ROW_DOWN );
}


void
on_up_button_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
  Select_Treeview_Row( SELECT_ROW_UP );
}


void
on_delete_button_clicked               (GtkButton       *button,
                                        gpointer         user_data)
{
  Delete_Station_Row();
}


void
on_new_button_clicked                  (GtkButton       *button,
                                        gpointer         user_data)
{
  New_Station_Row();
}


void
on_save_button_clicked                 (GtkButton       *button,
                                        gpointer         user_data)
{
  SetFlag( SAVE_STATIONS );
  Save_Stations_File();
}


void
on_time_window_destroy                 (GtkObject       *object,
                                        gpointer         user_data)
{
  Close_Time_Display();
  time_window = NULL;
}


void
on_time_station_combobox_changed       (GtkComboBox     *combobox,
                                        gpointer         user_data)
{
  Time_Combobox_Changed( combobox );
}


void
on_time_receive_togglebutton_toggled   (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
  Time_Togglebutton_Toggled( togglebutton );
}


void
on_time_quit_button_clicked            (GtkButton       *button,
                                        gpointer         user_data)
{
  /* Close time display window */
  if( time_window != NULL )
	gtk_widget_destroy( time_window );
}


gboolean
on_spectrum_window_delete_event        (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
  /* Stop FFT monitors */
  ClearFlag( MONITORS_START );
  ClearFlag( FFT_INITIALIZED );
  return FALSE;
}


void
on_spectrum_window_destroy             (GtkObject       *object,
                                        gpointer         user_data)
{
  /* Stop FFT monitors */
  spectrum_window = NULL;
  rc_data.monitor_width = 0;
  rc_data.spectrum_height = 0;
  rc_data.signal_height = 0;

  /* Stop sdrx and cleanup */
  if( isFlagClear(PLAYBACK_START) &&
	  isFlagClear(TIME_RECV_START) )
	Sdrx_Close_Device();

  gtk_toggle_button_set_active( GTK_TOGGLE_BUTTON(
	  lookup_widget(sdrx_main_window, "spectrum_togglebutton")), FALSE );
}


gboolean
on_signal_drawingarea_expose_event     (GtkWidget       *widget,
                                        GdkEventExpose  *event,
                                        gpointer         user_data)
{
  Signal_Drawingarea_Expose_Event();
  return TRUE;
}


gboolean
on_signal_drawingarea_button_press_event
                                        (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
  Tune_to_Monitor( event->x );
  return TRUE;
}


void
on_signal_drawingarea_size_allocate    (GtkWidget       *widget,
                                        GdkRectangle    *allocation,
                                        gpointer         user_data)
{
  rc_data.signal_height = allocation->height;
}


gboolean
on_signal_drawingarea_configure_event  (GtkWidget       *widget,
                                        GdkEventConfigure *event,
                                        gpointer         user_data)
{
  Signal_Drawingarea_Config_Event( widget, event );
  return FALSE;
}


gboolean
on_spectrum_drawingarea_expose_event   (GtkWidget       *widget,
                                        GdkEventExpose  *event,
                                        gpointer         user_data)
{
  if( spectrum_pixbuf != NULL )
  {
	gdk_draw_pixbuf(
		widget->window, NULL,
		spectrum_pixbuf,
		event->area.x, event->area.y,
		event->area.x, event->area.y,
		event->area.width, event->area.height,
		GDK_RGB_DITHER_NONE, 0, 0 );
  }

  return TRUE;
}


gboolean
on_spectrum_drawingarea_button_press_event
                                        (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
  Tune_to_Monitor( event->x );
  return TRUE;
}


void
on_spectrum_drawingarea_size_allocate  (GtkWidget       *widget,
                                        GdkRectangle    *allocation,
                                        gpointer         user_data)
{
  Spectrum_Drawingarea_Size_Alloc( SPECTRUM_DRAWINGAREA, widget, allocation );
}


void
on_usb_wide_activate                   (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  Mode_Combobox_Changed( USBW );
}


void
on_usb_medium_activate                 (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  Mode_Combobox_Changed( USBM );
}


void
on_usb_narrow_activate                 (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  Mode_Combobox_Changed( USBN );
}


void
on_lsb_wide_activate                   (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  Mode_Combobox_Changed( LSBW );
}


void
on_lsb_medium_activate                 (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  Mode_Combobox_Changed( LSBM );
}


void
on_lsb_narrow_activate                 (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  Mode_Combobox_Changed( LSBN );
}


void
on_cwu_wide_activate                   (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  Mode_Combobox_Changed( CWUW );
}


void
on_cwu_medium_activate                 (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  Mode_Combobox_Changed( CWUM );
}


void
on_cwu_narrow_activate                 (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  Mode_Combobox_Changed( CWUN );
}


void
on_cwl_wide_activate                   (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  Mode_Combobox_Changed( CWLW );
}


void
on_cwl_medium_activate                 (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  Mode_Combobox_Changed( CWLM );
}


void
on_cwl_narrow_activate                 (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  Mode_Combobox_Changed( CWLN );
}


void
on_am_wide_activate                    (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  Mode_Combobox_Changed( AMW );
}


void
on_am_narrow_activate                  (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  Mode_Combobox_Changed( AMN );
}


void
on_amsu_activate                       (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  Mode_Combobox_Changed( AMSU );
}


void
on_amsl_activate                       (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  Mode_Combobox_Changed( AMSL );
}


void
on_fm_wide_activate                    (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  Mode_Combobox_Changed( WBFM );
}


void
on_fm_medium_activate                  (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  Mode_Combobox_Changed( MBFM );
}


void
on_fm_narrow1_activate                 (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  Mode_Combobox_Changed( NBFM1 );
}


void
on_fm_narrow2_activate                 (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  Mode_Combobox_Changed( NBFM2 );
}

