/*
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 2 of
 *  the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details:
 *
 *  http://www.gnu.org/copyleft/gpl.txt
 */

#ifndef CALLBACK_FUNC_H
#define CALLBACK_FUNC_H		1

#include "monitors.h"
#include "demodulate.h"
#include "utils.h"

/* Signal modulation modes */
enum
{
  WBFM = 0,
  MBFM,
  NBFM1,
  NBFM2,
  AMW,
  AMN,
  AMSU,
  AMSL,
  USBW,
  USBM,
  USBN,
  LSBW,
  LSBM,
  LSBN,
  CWUW,
  CWUM,
  CWUN,
  CWLW,
  CWLM,
  CWLN
};

/* Bandwidth settings for
 * demodulator functions */
enum
{
  DEMOD_BW_100,
  DEMOD_BW_200,
  DEMOD_BW_400,
  DEMOD_BW_650,
  DEMOD_BW_950,
  DEMOD_BW_1000,
  DEMOD_BW_1500,
  DEMOD_BW_1900,
  DEMOD_BW_2200,
  DEMOD_BW_2800,
  DEMOD_BW_3000,
  DEMOD_BW_3800,
  DEMOD_BW_4500,
  DEMOD_BW_8k,
  DEMOD_BW_12k,
  DEMOD_BW_25k,
  DEMOD_BW_50k,
  DEMOD_BW_100k,
  DEMOD_BW_200k
};

/* Phasing frequencies for Weaver
 * method (SSB/CW) demodulators */
enum
{
  WEAVER_NONE = 0,
  WEAVER_500,
  WEAVER_600,
  WEAVER_800,
  WEAVER_1000,
  WEAVER_1200,
  WEAVER_1500,
  WEAVER_1600,
  WEAVER_2000,
  WEAVER_2400
};

/* RTLSDR DSP sampling rates */
enum
{
  RTL_RATE_288 = 0,
  RTL_RATE_1008,
  RTL_RATE_2016,
  RTL_RATE_3024
};

/* SDRPLAY DSP sampling rates */
enum
{
  RSP_RATE_384 = 0,
  RSP_RATE_768,
  RSP_RATE_1536,
  RSP_RATE_2000,
  RSP_RATE_4000,
  RSP_RATE_8000
};

/* PERSEUS DSP sampling rates */
enum
{
  PERSEUS_RATE_48  = 48,
  PERSEUS_RATE_96  = 96,
  PERSEUS_RATE_192 = 192
};

/* Buffer size for async streaming */
enum
{
  BUF_16 = 0,
  BUF_32,
  BUF_64,
  BUF_128,
  BUF_256,
};

/* Pointer to current demodulator function */
gboolean (*Demodulator)( int buf_len );

/* Pointer to Time Station receiver function */
void (*Receive_Time_Station)( void );

/* Radio time transmitters frequencies */
#define MSF60_FREQUENCY		60000
#define RBU66_FREQUENCY		66667
#define DCF77_FREQUENCY		77500
#define ALL162_FREQUENCY	162000

/* Range of Manual Gain Slider */
#define MAN_GAIN_RANGE		100.0

/* Range of Squelch Slider */
#define SQUELCH_RANGE		100.0

/* Scale values needed in demodulators, to bring sample
 * values sent to sound card in the range of a 'short int'
 * data type. These are for 8-bit ADC as in RTLSDR dongles */
#define WBFM_DEMOD_SCALE	0.3
#define MBFM_DEMOD_SCALE	2.0
#define NBFM1_DEMOD_SCALE	5.0
#define NBFM2_DEMOD_SCALE	10.0
#define AM_DEMOD_SCALE		150.0
#define SSB_DEMOD_SCALE		150.0
#define CW_DEMOD_SCALE		150.0

/* Aditional scale factor to account
 * for SDRPlay's 12-bit ADC */
#define SDRPLAY_DEMOD_SCALE		8.0

/* Aditional scale factor to account
 * for Perseus's 14-bit ADC */
#define PERSEUS_DEMOD_SCALE		64.0

#define SIGNAL_DRAWINGAREA		1
#define SPECTRUM_DRAWINGAREA	2

#endif

