/*
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 2 of
 *  the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details:
 *
 *  http://www.gnu.org/copyleft/gpl.txt
 */

#ifndef SHARED_H
#define SHARED_H	1

#include "common.h"

/* Runtime config data */
extern rc_data_t rc_data;

/* All-satellite TLE data */
extern element_set_t *element_sets;

/* Number of entries in tle_data */
extern int num_sets;

/* Index to global TLE data */
extern int set_idx;

/* Number of transponder modes found in database */
extern int num_modes;

/* Index to transponder modes buffer */
extern int mode_index;

/* All-observer location data */
extern observer_status_t *observer_data;

/* Number of entries in obs_data */
extern int num_obs;

/* Index to global observer data buffer */
extern int obs_idx;

/* Observer's status data */
extern observer_status_t observer_status;

/* Buffer for reading satellite transponder
   modes from the satellite database file */
extern satellite_mode_t *satellite_mode;

/* Satellite status data */
extern satellite_status_t satellite_status;

/* Change satellite or location */
extern int change_sat_loc;

/* Current satellite TLE data */
extern element_set_t satellite_element_set;

/* Transceiver status structure */
extern transceiver_status_t transceiver_status;

/* Azimuth and elevation demand to rotors */
extern double azimuth, elevation;

/* xplanet running flag */
extern gboolean xplanet;

extern GtkWidget
  *satellite_track,	  /* Main window */
  *illum_drawingarea, /* Illumination Predict drawingarea */
  *pass_drawingarea,  /* Pass Predict drawingarea */
  *illum_predict,	  /* Illumination Predict window */
  *multi_location,	  /* Multi Location window */
  *multi_satellite,	  /* Multi Satellite window */
  *pass_predict,	  /* Pass Predict window */
  *calibrate,  /* Calibration dialog */
  *dop_status, /* Doppler status label */
  *trk_status, /* Doppler status label */
  *rot_status, /* Antenna rotator status label  */
  *cat_status; /* Transceiver CAT status label  */

/* Main window builder */
extern GtkBuilder
  *satellite_track_builder;

#endif

