/*
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 3 of
 *  the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details:
 *
 *  http://www.gnu.org/copyleft/gpl.txt
 */

#ifndef INTERFACE_H
#define INTERFACE_H		1

#include "common.h"

#define AZEL_DIALOG_IDS \
"azel_dialog", \
"azel_apply", \
"azel_ok", \
"el_entry", \
"az_entry", \
NULL

#define CALIBRATION_IDS \
"calibration", \
"azim_scale", \
"elev_scale", \
"cal_label", \
NULL

#define ERROR_DIALOG_IDS \
"error_dialog", \
"error_quit", \
"error_ok", \
"error_mesg", \
NULL

#define ILLUM_PREDICT_IDS \
"illum_predict", \
"date_loc5", \
"sun_azel5", \
"obs_loc5", \
"obs_lon5", \
"time_loc5", \
"moon_range5", \
"obs_lat5", \
"date_utc5", \
"moon_azim5", \
"obs_height5", \
"time_utc5", \
"moon_elev5", \
"sat_name5", \
"sat_azim5", \
"elev_label5", \
"sat_elev5", \
"sat_range5", \
"illum_drawingarea", \
"ill_fwd", \
"ill_back", \
"ill_redo", \
"multi_sat5", \
"sat_up3", \
"sat_dn3", \
"sat_frst3", \
"sat_last3", \
NULL

#define LOC_DIALOG_IDS \
"loc_dialog", \
"loc_save", \
"loc_apply", \
"loc_close", \
"loc_name", \
"qth_loc", \
"lon_deg", \
"lat_deg", \
"loc_height", \
"lon_min", \
"lat_min", \
NULL

#define POPUP_MENU_IDS \
"popup_menu", \
"new_location", \
"position_rotors", \
"track_polar_star", \
"track_moon", \
"track_sun", \
"park_rotors", \
"offset_calibration", \
"fullscale_calibration", \
"download_tle", \
"quit", \
NULL

#define MULTI_LOCATION_IDS \
"multi_location", \
"date_loc4", \
"sun_azel4", \
"obs_loc4", \
"obs_lon4", \
"time_loc4", \
"moon_range4", \
"obs_lat4", \
"date_utc4", \
"moon_azim4", \
"obs_height4", \
"time_utc4", \
"moon_elev4", \
"sat_name4", \
"sat_azim4", \
"elev_label4", \
"sat_elev4", \
"sat_range4", \
"multiloc_treeview", \
"loc_up3", \
"loc_dn3", \
"home", \
"multi_sat3", \
"pass_pred3", \
"sat_up2", \
"sat_dn2", \
"sat_frst2", \
"sat_last2", \
NULL

#define MULTI_SATELLITE_IDS \
"multi_satellite", \
"date_loc2", \
"sun_azel2", \
"obs_loc2", \
"obs_lon2", \
"time_loc2", \
"moon_range2", \
"obs_lat2", \
"date_utc2", \
"moon_azim2", \
"obs_height2", \
"time_utc2", \
"moon_elev2", \
"sat_name2", \
"sat_azim2", \
"elev_label2", \
"sat_elev2", \
"sat_range2", \
"freeze_multisat", \
"multisat_treeview", \
"multi_loc1", \
"pass_pred1", \
"illum_pred1", \
"loc_up1", \
"loc_dn1", \
"loc_frst1", \
"loc_last1", \
NULL

#define PASS_PREDICT_IDS \
"pass_predict", \
"date_loc3", \
"sun_azel3", \
"obs_loc3", \
"obs_lon3", \
"time_loc3", \
"moon_range3", \
"obs_lat3", \
"date_utc3", \
"moon_azim3", \
"obs_height3", \
"time_utc3", \
"moon_elev3", \
"sat_name3", \
"sat_azim3", \
"elev_label3", \
"sat_elev3", \
"sat_range3", \
"pass_drawingarea", \
"pass_pred_label", \
"multi_sat2", \
"multi_loc2", \
"illum_pred2", \
"sat_up1", \
"sat_dn1", \
"sat_frst1", \
"sat_last1", \
"loc_up2", \
"loc_dn2", \
"loc_frst2", \
"loc_last2", \
NULL

#define SATELLITE_TRACK_IDS \
"satellite_track", \
"date_loc1", \
"sun_azel1", \
"obs_loc1", \
"obs_lon1", \
"time_loc1", \
"moon_range1", \
"obs_lat1", \
"date_utc1", \
"moon_azim1", \
"obs_height1", \
"time_utc1", \
"moon_elev1", \
"illum_label", \
"elev_label", \
"sat_model", \
"sat_aos", \
"sat_los", \
"sat_eclst", \
"sat_azim", \
"sat_elev", \
"sat_range", \
"sat_phase", \
"sat_doppler", \
"sat_lon", \
"sat_lat", \
"sat_alt", \
"sat_ftprnt", \
"sat_revnum", \
"sat_name", \
"rot_frame", \
"rot_azdem", \
"rot_azim", \
"rot_eldem", \
"rot_elev", \
"rotor_control", \
"cat_frame", \
"rx_dplr", \
"rx_freq", \
"rx_mode", \
"rx_doppler", \
"dnlink_smeter", \
"dnlink_freq", \
"dnlink_ploss", \
"smeter_pbar", \
"rx_label", \
"tx_mode", \
"tx_doppler", \
"tx_freq", \
"uplink_freq", \
"uplink_ploss", \
"uplink_poalc", \
"tx_dplr", \
"poalc_pbar", \
"tx_label", \
"txrx_track", \
"update_track", \
"doppler_corr", \
"mode_chng", \
"tcvr_cat", \
"start_togglebutton", \
"image1", \
"multi_sat", \
"multi_loc", \
"pass_pred", \
"illum_pred", \
"xplanet_plot", \
"multisat_plot", \
"sat_up", \
"sat_dn", \
"sat_frst", \
"sat_last", \
"loc_up", \
"loc_dn", \
"loc_frst", \
"loc_last", \
NULL

#endif
