/*
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 2 of
 *  the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details:
 *
 *  http://www.gnu.org/copyleft/gpl.txt
 */


#include "shared.h"

/*--------------------------------------------------------------------*/

/* Runtime config data */
rc_data_t rc_data;

/* All-satellite TLE data */
element_set_t *element_sets = NULL;

/* Number of entries in tle_data */
int num_sets;

/* Index to global TLE data */
int set_idx;

/* Buffer for reading satellite transponder
   modes from the satellite database file */
satellite_mode_t *satellite_mode = NULL;

/* Number of transponder modes found in database */
int num_modes;

/* Index to transponder modes buffer */
int mode_index;

/* All-observer location data */
observer_status_t *observer_data = NULL;

/* Index to global observer data buffer */
int obs_idx;

/* Number of entries in obs_data */
int num_obs;

/* Observer's status data */
observer_status_t observer_status;

/* Satellite status data */
satellite_status_t satellite_status;

/* Current satellite TLE data */
element_set_t satellite_element_set;

/* Change satellite or location */
int change_sat_loc = CLEAR_CHANGE;

/* Transceiver status structure */
transceiver_status_t transceiver_status;

/* Azimuth and elevation demand to rotors */
double azimuth, elevation;

/* xplanet running flag */
gboolean xplanet = XPLANET_STOPPED;

GtkWidget
  *satellite_track   = NULL, /* Main window */
  *illum_drawingarea = NULL, /* Illumination Predict drawingarea */
  *pass_drawingarea  = NULL, /* Pass Predict drawingarea */
  *illum_predict     = NULL, /* Illumination Predict window */
  *multi_location    = NULL, /* Multi Location window */
  *multi_satellite   = NULL, /* Multi Satellite window */
  *pass_predict      = NULL, /* Pass Predict window */
  *calibrate  = NULL, /* Calibration dialog */
  *dop_status = NULL, /* Doppler status label */
  *trk_status = NULL, /* Antenna tracking status label */
  *rot_status = NULL, /* Antenna rotator status label  */
  *cat_status = NULL; /* Transceiver CAT status label  */

GtkBuilder *satellite_track_builder = NULL; /* Pass predict builder */

/*--------------------------------------------------------------------*/

