/*
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 2 of
 *  the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details:
 *
 *  http://www.gnu.org/copyleft/gpl.txt
 */

#ifndef CAT_H
#define CAT_H   1

#include "common.h"

/* Mask for Rx S-Meter status */
#define FT847_SMETER    0x1F
#define FT857_SMETER    0x0F

/* Mask for Tx PO/ALC status */
#define FT847_PO_ALC    0x1F
#define FT857_PO_ALC    0x0F

/* Get/Set transceiver status */
#define GET_TCVR_STATUS         0x0001
#define SET_TCVR_STATUS         0x0002
#define INITIALIZE_TCVR         0x0004
#define SELECT_K3_MAIN_RX       0x0008
#define SELECT_K3_SUB_RX        0x0010
#define SELECT_K3_MAIN_TX       0x0020
#define SELECT_FT8x7_MAIN_RX    0x0040
#define SELECT_FT8x7_MAIN_TX    0x0080
#define SELECT_FT8x7_SAT_RX     0x0100
#define SELECT_FT8x7_SAT_TX     0x0200
#define CAT_SUBACTIONS          0x03F8

/* Mode number used in tx_mode and rx_mode */
/* K3 modes ANDed with 0x10 represent Narrow modes */
#define K3_MODE_CODES \
(char)0x01, (char)0x02, (char)0x03, (char)0x07, (char)0x13, \
(char)0x17, (char)0x05, (char)0x04, (char)0x15, (char)0x14, \
(char)0x06, (char)0x09, (char)0x06, (char)0x06
#define FT847_MODE_CODES \
(char)0x00, (char)0x01, (char)0x02, (char)0x03, (char)0x82, \
(char)0x83, (char)0x04, (char)0x08, (char)0x84, (char)0x88, \
(char)0x01, (char)0x00, (char)0x0A, (char)0x0C
#define FT857_MODE_CODES \
(char)0x00, (char)0x01, (char)0x02, (char)0x03, (char)0x02, \
(char)0x03, (char)0x04, (char)0x08, (char)0x04, (char)0x88, \
(char)0x01, (char)0x00, (char)0x0A, (char)0x0C
enum { LSB = 0, USB, CW, CWR, CWN, CWNR, AM, FM, AMN, FMN, DATA, DATAR, DIG, PKT };

/* Bandwidths for K3 modes in 10Hz units */
#define K3_FILTER_BW    210,210,40,40,10,10,210,1500,300,1500,100,100

#define RIG_DUPLEX      1
#define RIG_SIMPLEX     0

#define CTCSS_TONES \
   670,  693,  719,  744,  770,  797,  825,  854,  885,  915, \
   948,  974, 1000, 1035, 1072, 1109, 1148, 1188, 1230, 1273, \
  1318, 1365, 1413, 1462, 1514, 1567, 1622, 1679, 1738, 1799, \
  1862, 1928, 2035, 2107, 2181, 2257, 2336, 2418, 2503,       \
  0x3f, 0x39, 0x1f, 0x3e, 0x0f, 0x3d, 0x1e, 0x3c, 0x0e, 0x3b, \
  0x1d, 0x3a, 0x0d, 0x1c, 0x0c, 0x1b, 0x0b, 0x1a, 0x0a, 0x19, \
  0x09, 0x18, 0x08, 0x17, 0x07, 0x16, 0x06, 0x15, 0x05, 0x14, \
  0x04, 0x13, 0x03, 0x12, 0x02, 0x11, 0x01, 0x10, 0x00        \

#define NUM_CTCSS_TONES 39

/* Max number of retries to read() or write() serial port */
#define MAX_SERIAL_RETRIES  10

#endif

