/*  solar_lunar.h
 *
 *  Functions to calculate the position of sun and moon
 */

/*
 *  xsatcom: A X/GTK+ application to track satellites using the
 *  NORAD SGP4/SDP4 orbit calculation routines. The moon and sun
 *  are also tracked.
 *
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 2 of
 *  the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details:
 *
 *  http://www.gnu.org/copyleft/gpl.txt
 */

#ifndef SOLAR_LUNAR_H
#define SOLAR_LUNAR_H	1

#include "common.h"

/* Number of lunar perterbation terms used in Calculate_Moon_Position() */
#define PERTB_NTERMS    60

/* Lunar perturbation data */
typedef struct
{
  /* Multipliers for D, M, M' and F */
  int
	Dm, Ms, Mm, Fm;

  /* Coefficient of the sine or cosine of argument */
  double a;
} lunar_perturbation_t;


#endif

