/*  shared.h
 *
 *  Shared global varisbles
 */

/*
 *  xsatcom: A X/GTK+ application to track satellites using the
 *  NORAD SGP4/SDP4 orbit calculation routines. The moon and sun
 *  are also tracked.
 *
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 2 of
 *  the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details:
 *
 *  http://www.gnu.org/copyleft/gpl.txt
 */

#ifndef SHARED_H
#define SHARED_H	1

#include "common.h"

/* Runtime config data */
extern rc_data_t rc_data;

/* All-satellite TLE data */
extern elem_set_t *gbl_elem_sets;

/* Number of entries in tle_data */
extern int gbl_num_sets;

/* Index to global TLE data */
extern int gbl_set_idx;

/* Number of transponder modes found in database */
extern int gbl_num_modes;

/* Index to transponder modes buffer */
extern int gbl_mode_idx;

/* All-observer location data */
extern observer_status_t *gbl_obs_data;

/* Number of entries in gbl_obs_data */
extern int gbl_num_obs;

/* Index to global observer data buffer */
extern int gbl_obs_idx;

/* Observer's status data */
extern observer_status_t gbl_obs_status;

/* Buffer for reading satellite transponder
   modes from the satellite database file */
extern satellite_mode_t *gbl_sat_mode;

/* Satellite status data */
extern satellite_status_t gbl_sat_status;

/* Change satellite or location */
extern int gbl_change_sat_loc;

/* Transceiver status structure */
extern tcvr_status_t gbl_tcvr_status;

/* Azimuth and elevation demand to rotors */
extern double
  gbl_azim,
  gbl_elev;

/* xplanet running flag */
extern gboolean gbl_xplanet;

/* Main window */
extern GtkWidget *sat_track;

/* Illumination Predict plots drawingarea */
extern GtkWidget *illum_drawingarea;

/* Pass Predict plots drawingarea */
extern GtkWidget *pass_drawingarea;

#endif

