/*  shared.c
 *
 *  Shared global variables
 */

/*
 *  xsatcom: A X/GTK+ application to track satellites using the
 *  NORAD SGP4/SDP4 orbit calculation routines. The moon and sun
 *  are also tracked.
 *
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 2 of
 *  the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details:
 *
 *  http://www.gnu.org/copyleft/gpl.txt
 */


#include "shared.h"

/*--------------------------------------------------------------------*/

/* Runtime config data */
rc_data_t rc_data;

/* All-satellite TLE data */
elem_set_t *gbl_elem_sets = NULL;

/* Number of entries in tle_data */
int gbl_num_sets;

/* Index to global TLE data */
int gbl_set_idx;

/* Buffer for reading satellite transponder
   modes from the satellite database file */
satellite_mode_t *gbl_sat_mode = NULL;

/* Number of transponder modes found in database */
int gbl_num_modes;

/* Index to transponder modes buffer */
int gbl_mode_idx;

/* All-observer location data */
observer_status_t *gbl_obs_data = NULL;

/* Index to global observer data buffer */
int gbl_obs_idx;

/* Number of entries in gbl_obs_data */
int gbl_num_obs;

/* Observer's status data */
observer_status_t gbl_obs_status;

/* Satellite status data */
satellite_status_t gbl_sat_status;

/* Change satellite or location */
int gbl_change_sat_loc = CLEAR_CHANGE;

/* Transceiver status structure */
tcvr_status_t gbl_tcvr_status;

/* Azimuth and elevation demand to rotors */
double
  gbl_azim,
  gbl_elev;

/* xplanet running flag */
gboolean gbl_xplanet = XPLANET_STOPPED;

/* Main window */
GtkWidget *sat_track = NULL;

/* Illumination Predict plots drawingarea */
GtkWidget *illum_drawingarea = NULL;

/* Pass Predict plots drawingarea */
GtkWidget *pass_drawingarea = NULL;

/*--------------------------------------------------------------------*/

