/*
 * Initial main.c file generated by Glade. Edit as required.
 * Glade will not overwrite this file.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include "main.h"
#include "shared.h"

/* Signal handler */
static void sig_handler( int signal );

/*------------------------------------------------------------------------*/

  int
main (int argc, char *argv[])
{
  /* Command line option returned by getopt() */
  int option;

  /* New and old actions for sigaction() */
  struct sigaction sa_new, sa_old;


  /* Initialize new actions */
  sa_new.sa_handler = sig_handler;
  sigemptyset( &sa_new.sa_mask );
  sa_new.sa_flags = 0;

  /* Register function to handle signals */
  sigaction( SIGINT,  &sa_new, &sa_old );
  sigaction( SIGSEGV, &sa_new, 0 );
  sigaction( SIGFPE,  &sa_new, 0 );
  sigaction( SIGTERM, &sa_new, 0 );
  sigaction( SIGABRT, &sa_new, 0 );

  /* Process command line options */
  while( (option = getopt(argc, argv, "hv") ) != -1 )
	switch( option )
	{
	  case 'h' : /* Print usage and exit */
		Usage();
		return(0);

	  case 'v' : /* Print version */
		puts( PACKAGE_STRING );
		return(0);

	  default: /* Print usage and exit */
		Usage();
		exit(-1);

	} /* End of switch( option ) */

  /* Init GTK */
  gtk_set_locale ();
  gtk_init (&argc, &argv);

  /*
   * The following code was added by Glade to create one of each component
   * (except popup menus), just so that you see something after building
   * the project. Delete any components that you don't want shown initially.
   */
  sat_track = create_sat_track();
  gtk_window_set_title( GTK_WINDOW(sat_track), PACKAGE_STRING );

  /* Set labels to CAT and Rotor Enable buttons */
  {
	GtkWidget
	  *button,
	  *rot_status,
	  *cat_status,
	  *dop_status,
	  *trk_status;

	button = lookup_widget( sat_track, "rotor_control" );
	rot_status = gtk_label_new (_("Enable Rotors"));
	gtk_widget_show (rot_status);
	gtk_container_add (GTK_CONTAINER (button), rot_status);
	gtk_label_set_justify (GTK_LABEL (rot_status), GTK_JUSTIFY_LEFT);
	g_object_set_data_full (G_OBJECT (sat_track), "rot_status",
		gtk_widget_ref (rot_status), (GDestroyNotify) gtk_widget_unref);

	button = lookup_widget( sat_track, "tcvr_cat" );
	cat_status = gtk_label_new (_("Enable CAT"));
	gtk_widget_show (cat_status);
	gtk_container_add (GTK_CONTAINER (button), cat_status);
	gtk_label_set_justify (GTK_LABEL (cat_status), GTK_JUSTIFY_LEFT);
	g_object_set_data_full (G_OBJECT (sat_track), "cat_status",
		gtk_widget_ref (cat_status), (GDestroyNotify) gtk_widget_unref);

	button = lookup_widget( sat_track, "doppler_corr" );
	dop_status = gtk_label_new (_("Doppler"));
	gtk_widget_show (dop_status);
	gtk_container_add (GTK_CONTAINER (button), dop_status);
	gtk_label_set_justify (GTK_LABEL (dop_status), GTK_JUSTIFY_LEFT);
	g_object_set_data_full (G_OBJECT (sat_track), "dop_status",
		gtk_widget_ref (dop_status), (GDestroyNotify) gtk_widget_unref);

	button = lookup_widget( sat_track, "txrx_track" );
	trk_status = gtk_label_new (_("Tx/Rx Track"));
	gtk_widget_show (trk_status);
	gtk_container_add (GTK_CONTAINER (button), trk_status);
	gtk_label_set_justify (GTK_LABEL (trk_status), GTK_JUSTIFY_LEFT);
	g_object_set_data_full (G_OBJECT (sat_track), "trk_status",
		gtk_widget_ref (trk_status), (GDestroyNotify) gtk_widget_unref);
  }

  gtk_widget_show (sat_track);

  /* Load observer location data from xsatcom.obs */
  g_idle_add( Load_Config, NULL );

  gtk_main ();

  return 0;
}

/*------------------------------------------------------------------------*/

/*  Load_Config()
 *
 *  Loads the xsatcomrc configuration file
 */

  gboolean
Load_Config( gpointer data )
{
  char
	rc_fpath[64], /* File path to xsatcomrc */
	line[81];     /* Buffer for Load_Line  */

  /* Config file pointer */
  FILE *xsatcomrc;

  char *error;


  /* Setup file path to xsatcomrc */
  snprintf( rc_fpath, sizeof(rc_fpath),
	  "%s/.xsatcom/xsatcomrc", getenv("HOME") );

  /* Open xsatcomrc file */
  xsatcomrc = fopen( rc_fpath, "r" );
  if( xsatcomrc == NULL )
  {
	perror( rc_fpath );
	Error_Dialog(
		_("Failed to open xsatcomrc file\n"\
		  "Quit xsatcom and correct"), FATAL );
	return( FALSE );
  }

  /*** Read runtime configuration data ***/

  /* Read Transceiver type for  CAT, abort if EOF */
  if( Load_Line(line, xsatcomrc, 80,
		_("Transceiver type for CAT"), TRUE ) != SUCCESS )
	return( FALSE );
  if( strcmp(line, "FT847") == 0 )
	rc_data.tcvr_type = FT847;
  else if( strcmp(line, "FT857") == 0 )
	rc_data.tcvr_type = FT857;
  else if( strcmp(line, "K2") == 0 )
	rc_data.tcvr_type = K2;
  else if( strcmp(line, "K3") == 0 )
	rc_data.tcvr_type = K3;
  else if( strcmp(line, "NONE") == 0 )
	rc_data.tcvr_type = NONE;
  else
  {
	rc_data.tcvr_type = NONE;
	fclose( xsatcomrc );
	Error_Dialog(
		_("Error reading Transceiver type\n"\
		  "Quit and correct xsatcomrc"), FATAL );
	return( FALSE );
  }

  /* Read Transceiver serial device, abort on error */
  if( Load_Line(line, xsatcomrc, 80, _("Transceiver Serial"), TRUE) != SUCCESS )
	return( FALSE );
  Strlcpy( rc_data.cat_serial, line, sizeof(rc_data.cat_serial) );

  /* Read Rotor serial device, abort on error */
  if( Load_Line(line, xsatcomrc, 80, _("Rotor Serial"), TRUE) != SUCCESS )
	return( FALSE );
  Strlcpy( rc_data.rotor_serial, line, sizeof(rc_data.rotor_serial) );

  /* Read Rotor low resolution, abort on error */
  if( Load_Line(line, xsatcomrc, 80, _("Rotor Low resolution"), TRUE) != SUCCESS )
	return( FALSE );
  rc_data.low_resol = atoi(line);

  /* Read Rotor med resolution, abort on error */
  if( Load_Line(line, xsatcomrc, 80, _("Rotor Medium Resolution"), TRUE) != SUCCESS )
	return( FALSE );
  rc_data.med_resol = atoi(line);

  /* Read Rotor high resolution, abort on error */
  if( Load_Line(line, xsatcomrc, 80, _("Rotor High Resolution"), TRUE) != SUCCESS )
	return( FALSE );
  rc_data.high_resol = atoi(line);

  /* Read Azimuth parking position, abort on error */
  if( Load_Line(line, xsatcomrc, 80, _("Azimuth Parking Position"), TRUE) != SUCCESS )
	return( FALSE );
  rc_data.azim_parking = atoi(line);

  /* Read Elevation parking position, abort on error */
  if( Load_Line(line, xsatcomrc, 80, _("Elevation Parking Position"), TRUE) != SUCCESS )
	return( FALSE );
  rc_data.elev_parking = atoi(line);

  /* Read Rotor Azimuth offset, abort on error */
  if( Load_Line(line, xsatcomrc, 80, _("Rotor Azimuth Offset"), TRUE) != SUCCESS )
	return( FALSE );
  rc_data.azim_offset = atoi(line);

  /* Read AOS search angle step, abort on error */
  if( Load_Line(line, xsatcomrc, 80, _("AOS Search Angle Step"), TRUE) != SUCCESS )
	return( FALSE );
  rc_data.angle_step = atoi(line);

  /* Read AOS search time step, abort on error */
  if( Load_Line(line, xsatcomrc, 80, _("AOS Search Time Step"), TRUE) != SUCCESS )
	return( FALSE );
  rc_data.time_step = atoi(line);

  /* Read AOS search Horizon threshold, abort on error */
  if( Load_Line(line, xsatcomrc, 80, _("AOS Search Horizon Threshold"), TRUE) != SUCCESS )
	return( FALSE );
  rc_data.horizon = Atof(line);

  /* Read xplanet directory, abort on error */
  if( Load_Line(line, xsatcomrc, 80,
		_("Xplanet Directory"), TRUE) != SUCCESS )
	return( FALSE );
  line[31] = '\0';
  Strlcpy( rc_data.xplanet_config, line,
	  sizeof(rc_data.xplanet_config) );
  Strlcpy( rc_data.xplanet_marker, line,
	  sizeof(rc_data.xplanet_marker) );
  Strlcpy( rc_data.xplanet_gcarcs, line,
	  sizeof(rc_data.xplanet_gcarcs) );
  Strlcpy( rc_data.xplanet_satfile, line,
	  sizeof(rc_data.xplanet_satfile) );
  Strlcat( rc_data.xplanet_config, XPLANET_CONFIG,
	  sizeof(rc_data.xplanet_config) );
  Strlcat( rc_data.xplanet_marker, XPLANET_MARKER,
	  sizeof(rc_data.xplanet_marker) );
  Strlcat( rc_data.xplanet_gcarcs, XPLANET_GCARCS,
	  sizeof(rc_data.xplanet_gcarcs) );
  Strlcat( rc_data.xplanet_satfile, XPLANET_SATFLE,
	  sizeof(rc_data.xplanet_satfile) );

  /* Read xplanet command, abort on error */
  if( Load_Line(line, xsatcomrc, 80,
	  _("Xplanet Command"), TRUE) != SUCCESS )
	return( FALSE );
  size_t s = sizeof( rc_data.xplanet_command );
  Strlcpy( rc_data.xplanet_command, "xplanet ", s );
  Strlcat( rc_data.xplanet_command, line, s );
  Strlcat( rc_data.xplanet_command, " -config ", s );
  Strlcat( rc_data.xplanet_command, XPLANET_CONFIG, s );
  Strlcat( rc_data.xplanet_command, " &", s );

  /* Read WGF constant selection, abort on error */
  if( Load_Line(line, xsatcomrc, 80,
	  _("WGF Constant Selection"), TRUE) != SUCCESS )
	return( FALSE );
  rc_data.wgf = (char)atoi( line );
  if( (rc_data.wgf < 0) || (rc_data.wgf > 2) )
  {
	fclose( xsatcomrc );
	Error_Dialog(
		_("Error reading WGF selection\n"\
		"Quit xsatcom and correct"), FATAL );
	return( FALSE );
  }
  getgravconst();

  /* Load observer and tle data */
  error = Load_Observer_Data();
  if( strcmp(error, "OK!") != 0 )
  {
	fclose( xsatcomrc );
	Error_Dialog( error, FATAL );
	return( FALSE );
  }
  else
  {
	error = Load_Database_Tle_Data();
	if( strcmp(error, "OK!") != 0 )
	{
	  fclose( xsatcomrc );
	  Error_Dialog( error, FATAL );
	  return( FALSE );
	}
  }

  ClearFlag( DOPPLER_DISABLED );
  ClearFlag( NEW_DNLINK_FREQ );
  ClearFlag( NEW_UPLINK_FREQ );

  return( FALSE );
} /* End of Load_Config() */

/*------------------------------------------------------------------*/

/*  sig_handler()
 *
 *  Signal Action Handler function
 */
static void sig_handler( int signal ) __attribute__ ((noreturn));
static void sig_handler( int signal )
{
  /* Cleanup before exit */
  Cleanup();

  /* Exit according to signal */
  fprintf( stderr, "\n" );
  switch( signal )
  {
	case SIGINT :
	  fprintf( stderr, "%s\n",  _("xsatcom: Exiting via User Interrupt") );
	  break;

	case SIGSEGV :
	  fprintf( stderr, "%s\n",  _("xsatcom: Segmentation Fault") );
	  break;

	case SIGFPE :
	  fprintf( stderr, "%s\n",  _("xsatcom: Floating Point Exception") );
	  break;

	case SIGABRT :
	  fprintf( stderr, "%s\n",  _("xsatcom: Abort Signal received") );
	  break;

	case SIGTERM :
	  fprintf( stderr, "%s\n",  _("xsatcom: Termination Request received") );
  }

  exit( signal );

} /* End of sig_handler() */

/*------------------------------------------------------------------------*/

