/*  gui.h
 *
 *  GTK+ display routines for xsatcom
 */

/*
 *  xsatcom: A X/GTK+ application to track satellites using the
 *  NORAD SGP4/SDP4 orbit calculation routines. The moon and sun
 *  are also tracked.
 *
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 2 of
 *  the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details:
 *
 *  http://www.gnu.org/copyleft/gpl.txt
 */

#ifndef GUI_H
#define GUI_H	1

#include "common.h"
#include "interface.h"
#include "support.h"

#define SERIAL_FAIL     "<span foreground=\"darkred\">SERIAL FAIL!</span>"
#define NORM_TRACKING   "<span foreground=\"darkgreen\">Normal Tracking</span>"
#define MANUAL_TRACKING "<span foreground=\"darkgreen\">Manual Tracking</span>"
#define POLAR_TRACKING  "<span foreground=\"darkgreen\">Polar Star</span>"
#define MOON_TRACKING   "<span foreground=\"darkgreen\">Tracking Moon</span>"
#define SUN_TRACKING    "<span foreground=\"darkgreen\">Tracking Sun</span>"
#define ROTORS_PARKED   "<span foreground=\"darkgreen\">Rotors Parked</span>"
#define REV_TRACKING    "<span foreground=\"darkblue\">Reverse Tracking</span>"
#define ROT_RUNNING     "<span foreground=\"darkred\">Rotors Running</span>"
#define CAT_ENABLE      "<span foreground=\"darkgreen\">CAT Enabled</span>"
#define SAT_ECLIPSE     "<span foreground=\"darkred\">Sat. Illumination</span>"
#define SAT_ILLUMIN     "<span foreground=\"darkgreen\">Sat. Illumination</span>"
#define SAT_ECLIPSE     "<span foreground=\"darkred\">Sat. Illumination</span>"
#define SAT_ILLUMIN     "<span foreground=\"darkgreen\">Sat. Illumination</span>"
#define SAT_NOACCESS    "<span foreground=\"darkred\">     Elevation deg</span>"
#define SAT_ACCESS      "<span foreground=\"darkgreen\">     Elevation deg</span>"
#define PASS_NOACCESS   "<span foreground=\"darkred\">   Elevation</span>"
#define PASS_ACCESS     "<span foreground=\"darkgreen\">   Elevation</span>"

#endif

