#!/bin/sh
#
# Script to download TLE files from celestrak.com
#
STS=http://celestrak.com/NORAD/elements/sts.txt
SPSTATIONS=http://celestrak.com/NORAD/elements/stations.txt
WEATHER=http://celestrak.com/NORAD/elements/weather.txt
NOAA=http://celestrak.com/NORAD/elements/noaa.txt
GOES=http://celestrak.com/NORAD/elements/goes.txt
GEO=http://celestrak.com/NORAD/elements/geo.txt
AMATEUR=http://celestrak.com/NORAD/elements/amateur.txt
VISIBLE=http://celestrak.com/NORAD/elements/visual.txt
CUBESAT=http://celestrak.com/NORAD/elements/cubesat.txt
#
LOG=~/.xsatcom/wget.log
#
# Uncomment or comment lines to download required files
#
# wget $STS
# wget $SPSTATIONS
# wget $NOAA
# wget $GOES
# wget $GEO
# wget $VISIBLE
echo "get_tle: Downloading TLE file(s)"
cd ~/.xsatcom &&
wget $AMATEUR &&
wget $WEATHER &&
wget $CUBESAT &&
echo "get_tle: Downloaded TLE file(s)" &&

rm xsatcom.tle
cat *.txt > xsatcom.tle &&
echo "get_tle: Created xsatcom.tle file" &&
rm  *.txt &&

# rm ~/.satcom/satcom.tle
# cp xsatcom.tle ~/.satcom/satcom.tle &&
# echo "get_tle: Created satcom.tle file"

rm /usr/share/xplanet/satellites/xsatcom.tle
cp xsatcom.tle /usr/share/xplanet/satellites/xsatcom.tle &&
echo "get_tle: Created xplanet xsatcom.tle file" &&
echo "get_tle: TLE file(s) download completed"
#
