/* Initialization of message structures */

#include "rwgps.h"
#include <math.h>

  int
main( void )
{
  int idx;
  message101_t  message101;
  message102_t  message102;
  message103_t  message103;

  /* Initialise message101 with the extreme values of data */
  message101.bit_summary 	  = 0x1f01;
  message101.low_ram_test	  = 0xffff;
  message101.high_ram_test	  = 0xffff;
  message101.preproc_test	  = 0x1f1f;
  message101.preproc_ram_test = 0xffff;
  message101.interface_test	  = 0x0301;
  message101.vco_test		  = 0x1f1f;
  message101.gen_inject_test  = 0x1f1f;
  message101.serial_errors	  = 0x7fff;
  message101.checksum_errors  = 0x7fff;
  message101.eeprom_prog_err  = 0x7fff;
  message101.eeprom_cksum_err = 0x7fff;
  message101.aux_port_errors  = 0x7fff;
  message101.software_config  = 0x000f;
  message101.software_version = 9.99;

  /* Initialise message102 with the extreme values of data */
  message102.set_time		= 0x7fffffff;
  message102.time_of_week	= 604800.0;
  message102.week_number	= 0x7fff;
  message102.num_visible_sats = 9;
  for ( idx = 0; idx < 9; idx++ )
  {
	message102.satellite_prn[ idx ] = 32;
	message102.satellite_ele[ idx ] = M_PI_2;
	message102.satellite_azi[ idx ] = M_2_PI;
  };

  /* Initialise message103 with the extreme values of data */
  message103.time_of_week	 = 604800.0;
  message103.week_number	 = 32767;
  message103.utc_validity	 = 1;
  message103.time_of_day	 = 86400.0;
  message103.utc_day		 = 31;
  message103.utc_month		 = 12;
  message103.utc_year		 = 2048;
  message103.set_time		 = 0X7FFFFFFF;
  message103.position_x		 = 9.0E06;
  message103.position_y		 = 9.0E06;
  message103.position_z 	 = 9.0E06;
  message103.velocity_east	 = 1000.0;
  message103.velocity_north	 = 1000.0;
  message103.velocity_up	 = 1000.0;
  message103.latitude_north	 = M_PI_2;
  message103.longitude_east	 = M_PI;
  message103.altitude_meters = 5.0E04;
  for ( idx = 0; idx < 5; idx++ )
	message103.prec_dilution[ idx ] = 32767;
  for ( idx = 0; idx < 5; idx++ )
  {
	message103.channel_state[ idx ] = 0x5A1F;
	message103.channel_cno[ idx ]   = 0X3F00;
  }
  message103.error_horiz    = 32767;
  message103.error_vert     = 32767;
  message103.error_time     = 32767;
  message103.error_velocity = 32767;
  message103.status_word1   = 0x000D;
  message103.status_word2   = 0xFFFF;

}
