/*
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 3 of
 *  the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details:
 *
 *  http://www.gnu.org/copyleft/gpl.txt
 */

#ifndef PLL_H
#define PLL_H   1

#include <complex.h>
#include <stdint.h>

typedef enum
{
  QPSK = 1, /* Standard QPSK as for Meteor M2 @72k sym rate */
  DOQPSK,   /* Differential Offset QPSK as for Meteor M2-2 @72k sym rate */
  IDOQPSK   /* Interleaved DOQPSK as for Meteor M2-2 @80k sym rate */
} ModScheme;

typedef struct
{
  double  nco_phase, nco_freq;
  double  alpha, beta;
  double  damping, bandwidth;
  uint8_t locked;
  double  moving_average;
  ModScheme mode;
} Costas_t;

/* pll.c */
Costas_t *Costas_Init(double bw, ModScheme mode);
complex double Costas_Mix(Costas_t *self, complex double samp);
void Costas_Correct_Phase(Costas_t *self, double error);
void Costas_Recompute_Coeffs(Costas_t *self, double damping, double bw);
void Costas_Free(Costas_t *self);
double Costas_Delta(complex double sample, complex double cosample);

#endif

