/*
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 3 of
 *  the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details:
 *
 *  http://www.gnu.org/copyleft/gpl.txt
 */

#ifndef FILTERS_H
#define FILTERS_H    1

#include <complex.h>
#include <stdint.h>

typedef struct
{
  complex double *restrict memory;
  uint32_t fwd_count;
  uint32_t stage_no;
  double  *restrict fwd_coeff;
} Filter_t;

/* filters.c */
void Filter_New(Filter_t **flt, uint32_t fwd_count, double *fwd_coeff);
void Filter_RRC(Filter_t **rrc, uint32_t order, double osf, double alpha);
complex double Filter_Fwd(Filter_t *const self, complex double in);
void Filter_Free(Filter_t *self);

#endif

