/*
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 3 of
 *  the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details:
 *
 *  http://www.gnu.org/copyleft/gpl.txt
 */

#ifndef HUFFMAN_H
#define HUFFMAN_H   1

#include <stdint.h>
#include <stddef.h>

extern int ac_lookup[65536], dc_lookup[65536];

/*------------------------------------------------------------------------*/

  inline int
Get_AC( const uint16_t w )
{
  return( ac_lookup[w] );
}

/*------------------------------------------------------------------------*/

  inline int
Get_DC( const uint16_t w )
{
  return( dc_lookup[w] );
}

/*------------------------------------------------------------------------*/

/* Decoder AC table data */
typedef struct
{
  int run, size, len;
  uint32_t mask, code;
} ac_table_rec_t;

extern ac_table_rec_t *ac_table;
extern size_t ac_table_len;

/* huffman.c */
int Map_Range(const int cat, const int vl);
void Default_Huffman_Table(void);

#endif

