/*
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 3 of
 *  the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details:
 *
 *  http://www.gnu.org/copyleft/gpl.txt
 */

#ifndef CORRELATOR_H
#define CORRELATOR_H    1

#include "viterbi27.h"
#include <stdint.h>

/* LRPT Decoder data */
#define PATTERN_SIZE        64
#define PATTERN_CNT         8
#define CORR_LIMIT          55
#define HARD_FRAME_LEN      1024
#define MIN_CORRELATION     45

extern int corr_tab[256][256];

/* Decoder correlator data */
typedef struct
{
  uint8_t patts[PATTERN_SIZE][PATTERN_SIZE];

  int
    correlation[PATTERN_CNT],
    tmp_corr[PATTERN_CNT],
    position[PATTERN_CNT];
} corr_rec_t;

/*------------------------------------------------------------------------*/

  inline int
Hard_Correlate( const uint8_t d, const uint8_t w )
{
  return( corr_tab[d][w] );
}

/*------------------------------------------------------------------------*/

/* correlator.c */
void Init_Correlator_Tables(void);
void Fix_Packet(void *data, int len, int shift);
void Correlator_Init(corr_rec_t *c, uint64_t q);
int Corr_Correlate(corr_rec_t *c, uint8_t *data, uint32_t len);

/*------------------------------------------------------------------------*/

#endif

