/*
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 2 of
 *  the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details:
 *
 *  http://www.gnu.org/copyleft/gpl.txt
 */


#ifndef COMMON_H
#define COMMON_H    1

/* Flow control flags */
#define STATUS_RECEIVING        0x00000001 /* SDR Receiver Running or Not     */
#define STATUS_STREAMING        0x00000002 /* SDR Receiver Streaming or Not   */
#define STATUS_SOAPYSDR_INIT    0x00000004 /* SoapySDR Device's Init Status   */
#define STATUS_PENDING          0x00000008 /* Wait for an Outstanding Status  */
#define STATUS_IDOQPSK_STOP     0x00000010 /* Stop decoding IDOQPSK (80k mde) */
#define STATUS_FLAGS_ALL        0x0000001F /* All Status Flags (to Clear)     */
#define ALARM_ACTION_START      0x00000020 /* Start Operation on SIGALRM      */
#define ALARM_ACTION_STOP       0x00000040 /* Stop Operation on SIGALRM       */
#define START_STOP_TIMER        0x00000080 /* Start-Stop Timer is activated   */
#define ENABLE_DECODE_TIMER     0x00000100 /* Enable Decode Operation Timer   */
#define IMAGE_RAW               0x00000200 /* Save image in raw decoded state */
#define IMAGE_NORMALIZE         0x00000400 /* Histogram normalize Wx image    */
#define IMAGE_CLAHE             0x00000800 /* CLAHE image contrast enhance    */
#define IMAGE_COLORIZE          0x00001000 /* Pseudo colorize wx image        */
#define IMAGE_COLORIZED         0x00002000 /* Pseudo colorize wx image        */
#define IMAGE_INVERT            0x00004000 /* Rotate wx image 180 degrees     */
#define IMAGES_PROCESSED        0x00008000 /* Images have been processed OK   */
#define IMAGE_RECTIFY           0x00010000 /* Rectify (stretch) wx image      */
#define IMAGES_RECTIFIED        0x00020000 /* Images Rectified OK             */
#define IMAGE_OUT_SPLIT         0x00040000 /* Save individual channel image   */
#define IMAGE_OUT_COMBO         0x00080000 /* Combine & save channel images   */
#define IMAGE_SAVE_JPEG         0x00100000 /* Save channel images as JPEG     */
#define IMAGE_SAVE_PPGM         0x00200000 /* Save channel image as PGM|PPM   */
#define TUNER_GAIN_AUTO         0x00400000 /* Set tuner gain to auto mode     */
#define AUTO_DETECT_SDR         0x00800000 /* Auto detect SDR device & driver */
#define FRAME_OK_ICON           0x01000000 /* Decoder Frame icon showing OK   */

/*---------------------------------------------------------------------------*/

/* Size of char arrays (strings) for error messages etc */
#define MESG_SIZE   128

/* Return values */
#define ERROR       1
#define SUCCESS     0

/* Boolean values defined here to avoid using GTK's own */
#ifndef Bool
  #define Bool uint8_t
#endif

#ifndef True
  #define True 1
#endif

#ifndef False
  #define False 0
#endif

/* Should have been in math.h */
#ifndef M_2PI
  #define M_2PI     6.28318530717958647692
#endif

/*---------------------------------------------------------------------------*/

/*
 * Standard gettext macros.
 */
#ifdef ENABLE_NLS
#  include <libintl.h>
#  undef _
#  define _(String) dgettext (PACKAGE, String)
#  define Q_(String) g_strip_context ((String), gettext (String))
#  ifdef gettext_noop
#    define N_(String) gettext_noop (String)
#  else
#    define N_(String) (String)
#  endif
#else
#  define textdomain(String) (String)
#  define gettext(String) (String)
#  define dgettext(Domain,Message) (Message)
#  define dcgettext(Domain,Message,Type) (Message)
#  define bindtextdomain(Domain,Directory) (Domain)
#  define _(String) (String)
#  define Q_(String) g_strip_context ((String), (String))
#  define N_(String) (String)
#endif

/*---------------------------------------------------------------------*/

#endif

