/*
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 2 of
 *  the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details:
 *
 *  http://www.gnu.org/copyleft/gpl.txt
 */

#ifndef UTILS_H
#define UTILS_H     1

#include "../Glrpt/jpeg.h"
#include "../common/common.h"
#include <stdint.h>
#include <stdio.h>

/*------------------------------------------------------------------------*/

 /* Max length for filenames */
#define MAX_FILE_NAME   128

/* Max and Min filter bandwidth */
#define MIN_BANDWIDTH   100000
#define MAX_BANDWIDTH   200000

/* Maximum time duration in sec
 * of satellite signal processing */
#define MAX_OPERATION_TIME  1000

/* Clamp_Int8()
 *
 * Clamp a real value to a int8_t
 */
  inline int8_t
Clamp_Int8( double x )
{
  if( x < -128.0 ) return( -128 );
  if( x >  127.0 ) return(  127 );
  if( (x >  0.0) && (x < 1.0) ) return(  1 );
  if( (x > -1.0) && (x < 0.0) ) return( -1 );
  return( (int8_t)x );
} /* Clamp_Int8() */

/*------------------------------------------------------------------------*/

/* Clamp_Double()
 *
 * Clamp a real value in the range [-max_abs, max_abs]
 */
  inline double
Clamp_Double( double x, double max_abs )
{
  if( x >  max_abs ) return(  max_abs );
  if( x < -max_abs ) return( -max_abs );
  return( x );
} /* Clamp_Double() */

/*------------------------------------------------------------------------*/

/* Clamps a double value between min and max */
  inline double
dClamp( double x, double min, double max )
{
  double ret = x;
  if( x < min ) ret = min;
  else if( x > max ) ret = max;
  return( ret );
}

/*------------------------------------------------------------------*/

/* Clamps an integer value between min and max */
  inline int
iClamp( int i, int min, int max )
{
  int ret = i;
  if( i < min ) ret = min;
  else if( i > max ) ret = max;
  return( ret );
}

/*------------------------------------------------------------------*/

/* utils.c */
void File_Name(char *file_name, uint32_t chn, const char *ext);
void Usage(void);
void Mem_Alloc(void **ptr, size_t req);
void Mem_Realloc(void **ptr, size_t req);
void Mem_Free(void **ptr);
Bool Open_File(FILE **fp, char *fname, const char *mode);
void Save_Image_JPEG(char *file_name, int width, int height, int num_channels, const uint8_t *pImage_data, compression_params_t *comp_params);
void Save_Image_Raw(char *fname, const char *type, uint32_t width, uint32_t height, uint32_t max_val, uint8_t *buffer);
int isFlagSet(int flag);
int isFlagClear(int flag);
void SetFlag(int flag);
void ClearFlag(int flag);
void ToggleFlag(int flag);
void Strlcpy(char *dest, const char *src, size_t n);
void Strlcat(char *dest, const char *src, size_t n);
double Atof(const char *nptr);

/*---------------------------------------------------------------------------*/

#endif

