/*
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 2 of
 *  the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details:
 *
 *  http://www.gnu.org/copyleft/gpl.txt
 */

#ifndef RC_CONFIG_H
#define RC_CONFIG_H     1

#include <gtk/gtk.h>
#include <stdint.h>

/*---------------------------------------------------------------------------*/

/* Number of APID image channels */
#define CHANNEL_IMAGE_NUM   3

/* Max and Min filter bandwidth */
#define MIN_BANDWIDTH   100000
#define MAX_BANDWIDTH   200000

/* Maximum time duration in sec
 * of satellite signal processing */
#define MAX_OPERATION_TIME  1000

/*---------------------------------------------------------------------------*/

/* Runtime config data */
typedef struct
{
  /* glrpt working directory and glade file */
  char
    glrpt_dir[64],
    glrpt_glade[64];

  uint32_t
    invert_palette[3],  /* Image APID to invert palette (black<-->white) */
    image_scale,        /* Scale factor to fit images in glrpt live display */
    decode_timer,       /* Time duration in sec of image decoding operation */
    default_timer;      /* Default timer length in sec for image decoding   */

  char satellite_name[32]; /* Name of selected satellite */

  /* SoapySDR Configuration */
  char device_driver[32];  /* Device driver name */
  uint32_t device_index;   /* Device index */

  /* SDR Receiver configuration */
  int freq_correction; /* Freq correction factor in ppm */

  uint32_t
    sdr_center_freq, /* Center Frequency for SDR Tuner */
    sdr_samplerate,  /* SDR RX ADC sample rate */
    sdr_buf_length,  /* SDR RX ADC samples buffer length */
    sdr_filter_bw;   /* SDR Low Pass Filter Bandwidth */

  /* SDR receiver tuner gain */
  double tuner_gain;

  /* Integer FFT factors */
  uint32_t ifft_decimate; /* FFT stride (decimation) */

  /* LRPT Demodulator Parameters */
  double
    demod_samplerate,   /* SDR Rx I/Q Sample Rate S/s */
    rrc_alpha,          /* Raised Root Cosine alpha factor */
    costas_bandwidth,   /* Costas PLL Loop Bandwidth */
    pll_locked,         /* Lower phase error threshold for PLL lock */
    pll_unlocked;       /* Upper phase error threshold for PLL unlock */

  uint32_t
    rrc_order,          /* Raised Root Cosine filter order */
    symbol_rate,        /* Transmitted QPSK Symbol Rate Sy/s */
    oversampling;       /* Demodulator Oversampling factor */

  /* LRPT Decoder Parameters (channel apid) */
  uint8_t apid[CHANNEL_IMAGE_NUM];

  /* Channels to combine to produce color image */
  uint8_t color_channel[CHANNEL_IMAGE_NUM];

  /* Image Normalization pixel value ranges */
  uint8_t norm_range[CHANNEL_IMAGE_NUM][2];

  uint8_t
    psk_mode,          /* Select QPSK or OQPSK demodulator */
    rectify_function,  /* Select rectification function, either W2RG or 5B4AZ */
    clouds_threshold,  /* Pixel values above which we assumed it is cloudy areas */
    colorize_blue_max, /* Max value of blue pixels to enhance in pseudo-colorized image */
    colorize_blue_min; /* Min value of blue pixels in pseudo-colorized image */

  float jpeg_quality;  /* JPEG compressor quality factor */

} rc_data_t;

/*---------------------------------------------------------------------------*/

/* rc_config.c */
gboolean Load_Config(void);
gboolean Find_Config_Files(gpointer data);

/*---------------------------------------------------------------------------*/

#endif

