/*
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 3 of
 *  the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details:
 *
 *  http://www.gnu.org/copyleft/gpl.txt
 */

#include "interface.h"
#include "rc_config.h"
#include "../common/common.h"
#include "../common/shared.h"
#include <gtk/gtk.h>
#include <stdlib.h>
#include <stdio.h>


/* Gtk Builder object ids */
#define ERROR_DIALOG_IDS \
  "error_dialog", \
  "error_ok_button", \
  "error_quit_button", \
  NULL

#define POPUP_MENU_IDS \
  "popup_menu", \
  "decode_timer_menuitem", \
  "auto_timer_menuitem", \
  "cancel_timer_menuitem", \
  "select_satellite", \
  "select_satellite_menu", \
  "raw_menuitem", \
  "normalize_menuitem", \
  "clahe_menuitem", \
  "rectify_menuitem", \
  "invert_menuitem", \
  "combine_menuitem", \
  "individual_menuitem", \
  "pseudo_menuitem", \
  "jpeg_menuitem", \
  "pgm_menuitem", \
  "quit_menuitem", \
  NULL

#define MAIN_WINDOW_IDS \
  "main_window", \
  "image_scrolledwindow", \
  "image_viewport", \
  "lrpt_image", \
  "satellite_label", \
  "text_scrolledwindow", \
  "message_textview", \
  "qpsk_drawingarea", \
  "ifft_drawingarea", \
  "sdr_freq_entry", \
  "sdr_bw_entry", \
  "sdr_tuner_entry", \
  "sdr_gain_scale", \
  "sdr_gain_adjust", \
  "start_togglebutton", \
  "manual_gain_radiobutton", \
  "auto_gain_radiobutton", \
  "pll_ave_entry", \
  "pll_freq_entry", \
  "pll_lock_icon", \
  "frame_icon", \
  "status_icon", \
  "sig_level_entry", \
  "sig_quality_entry", \
  "agc_gain_entry", \
  "packet_cnt_entry", \
  "ob_time_entry", \
  "sig_level_drawingarea", \
  "on_sig_qual_drawingarea", \
  "agc_gain_drawingarea", \
  "on_pll_ave_drawingarea", \
  NULL

#define QUIT_DIALOG_IDS \
  "quit_dialog", \
  "quit_cancel_button", \
  NULL

#define AUTO_TIMER_DIALOG_IDS \
  "auto_timer_dialog", \
  "auto_timer_cancel_button", \
  "auto_timer_ok_button", \
  NULL

#define OPER_TIMER_DIALOG_IDS \
  "decode_timer_dialog", \
  "decode_timer_ok_button", \
  "decode_timer_adj", \
  "decode_timer_spinbutton", \
  NULL

/*------------------------------------------------------------------*/

/* Gtk_Builder()
 *
 * Returns a GtkBuilder with required objects from file
 */
  static void
Gtk_Builder( GtkBuilder **builder, gchar **object_ids )
{
  GError *gerror = NULL;
  int ret = 0;

  /* Create a builder from object ids */
  *builder = gtk_builder_new();
  ret = (int)gtk_builder_add_objects_from_file(
      *builder, rc_data.glrpt_glade, object_ids, &gerror );
  if( !ret )
  {
    fprintf( stderr,
        _("glrpt: Failed to add objects to builder:\n%s\n"),
        gerror->message );
    g_free( gerror );
    exit( -1 );
  }
  g_free( gerror );

  /* Connect signals if gmodule is supported */
  if( !g_module_supported() )
  {
    fprintf( stderr, _("glrpt: lib gmodule not supported\n") );
    exit( -1 );
  }
  gtk_builder_connect_signals( *builder, NULL );

} /* Gtk_Builder() */

/*------------------------------------------------------------------*/

/* Builder_Get_Object()
 *
 * Gets a named object from the GtkBuilder builder object
 */
  GtkWidget *
Builder_Get_Object( GtkBuilder *builder, gchar *name )
{
  GObject *object = gtk_builder_get_object( builder, name );
  if( object == NULL )
  {
    fprintf( stderr,
        _("!! glrpt: builder failed to get named object: %s\n"),
        name );
    exit( -1 );
  }

  return( GTK_WIDGET(object) );
} /* Builder_Get_Object() */

/*------------------------------------------------------------------*/

/*
 * These functions below create various widgets using GtkBuilder
 */
  GtkWidget *
Create_Main_Window( GtkBuilder **builder )
{
  gchar *object_ids[] = { MAIN_WINDOW_IDS };
  Gtk_Builder( builder, object_ids );
  GtkWidget *window = Builder_Get_Object( *builder, "main_window" );
  return( window );
}

/*------------------------------------------------------------------*/

  GtkWidget *
Create_Popup_Menu( GtkBuilder **builder )
{
  gchar *object_ids[] = { POPUP_MENU_IDS };
  Gtk_Builder( builder, object_ids );
  GtkWidget *menu = Builder_Get_Object( *builder, "popup_menu" );
  return( menu );
}

/*------------------------------------------------------------------*/

  GtkWidget *
Create_Timer_Dialog( GtkBuilder **builder )
{
  gchar *object_ids[] = { OPER_TIMER_DIALOG_IDS };
  Gtk_Builder( builder, object_ids );
  GtkWidget *dialog =
    Builder_Get_Object( *builder, "decode_timer_dialog" );
  return( dialog );
}

/*------------------------------------------------------------------*/

  GtkWidget *
Create_Error_Dialog( GtkBuilder **builder )
{
  gchar *object_ids[] = { ERROR_DIALOG_IDS };
  Gtk_Builder( builder, object_ids );
  GtkWidget *dialog = Builder_Get_Object( *builder, "error_dialog" );
  return( dialog );
}

/*------------------------------------------------------------------*/

  GtkWidget *
Create_Startstop_Timer( GtkBuilder **builder )
{
  gchar *object_ids[] = { AUTO_TIMER_DIALOG_IDS };
  Gtk_Builder( builder, object_ids );
  GtkWidget *dialog = Builder_Get_Object( *builder, "auto_timer_dialog" );
  return( dialog );
}

/*------------------------------------------------------------------*/

  GtkWidget *
Create_Quit_Dialog( GtkBuilder **builder )
{
  gchar *object_ids[] = { QUIT_DIALOG_IDS };
  Gtk_Builder( builder, object_ids );
  GtkWidget *dialog = Builder_Get_Object( *builder, "quit_dialog" );
  return( dialog );
}

/*------------------------------------------------------------------*/

