/*
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 3 of
 *  the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details:
 *
 *  http://www.gnu.org/copyleft/gpl.txt
 */

#ifndef CALLBACKS_H
#define CALLBACKS_H     1

#include "interface.h"
#include <cairo.h>
#include <gtk/gtk.h>

/*---------------------------------------------------------------------------*/

/* callbacks.c */
void on_main_window_destroy(GObject *object, gpointer user_data);
gboolean on_main_window_delete_event(GtkWidget *widget, GdkEvent *event, gpointer user_data);
gboolean on_image_viewport_button_press_event(GtkWidget *widget, GdkEventButton *event, gpointer user_data);
void on_decode_timer_dialog_destroy(GObject *object, gpointer user_data);
void on_decode_timer_ok_button_clicked(GtkButton *button, gpointer user_data);
void on_auto_timer_cancel_button_clicked(GtkButton *button, gpointer user_data);
void on_auto_timer_ok_button_clicked(GtkButton *button, gpointer user_data);
void on_auto_timer_hrs_changed(GtkEditable *editable, gpointer user_data);
void on_auto_timer_min_changed(GtkEditable *editable, gpointer user_data);
void on_auto_times_activate(GtkEntry *entry, gpointer user_data);
void on_auto_stop_min_activate(GtkEntry *entry, gpointer user_data);
void on_auto_timer_destroy(GObject *object, gpointer user_data);
void on_save_images_menuitem_activate(GtkMenuItem *menuitem, gpointer user_data);
void on_decode_timer_menuitem_activate(GtkMenuItem *menuitem, gpointer user_data);
void on_auto_timer_menuitem_activate(GtkMenuItem *menuitem, gpointer user_data);
void on_cancel_timer_menuitem_activate(GtkMenuItem *menuitem, gpointer user_data);
void on_satellite_menuitem_activate(GtkMenuItem *menuitem, gpointer user_data);
void on_raw_menuitem_toggled(GtkCheckMenuItem *menuitem, gpointer user_data);
void on_normalize_menuitem_toggled(GtkCheckMenuItem *menuitem, gpointer user_data);
void on_clahe_menuitem_toggled(GtkCheckMenuItem *menuitem, gpointer user_data);
void on_rectify_menuitem_toggled(GtkCheckMenuItem *menuitem, gpointer user_data);
void on_invert_menuitem_toggled(GtkCheckMenuItem *menuitem, gpointer user_data);
void on_combine_menuitem_toggled(GtkCheckMenuItem *menuitem, gpointer user_data);
void on_individual_menuitem_toggled(GtkCheckMenuItem *menuitem, gpointer user_data);
void on_pseudo_menuitem_toggled(GtkCheckMenuItem *menuitem, gpointer user_data);
void on_jpeg_menuitem_toggled(GtkCheckMenuItem *menuitem, gpointer user_data);
void on_pgm_menuitem_toggled(GtkCheckMenuItem *menuitem, gpointer user_data);
void on_quit_menuitem_activate(GtkMenuItem *menuitem, gpointer user_data);
gboolean on_error_dialog_delete_event(GtkWidget *widget, GdkEvent *event, gpointer user_data);
void on_quit_dialog_destroy(GObject *object, gpointer user_data);
void on_error_dialog_destroy(GObject *object, gpointer user_data);
void on_error_ok_button_clicked(GtkButton *button, gpointer user_data);
void on_error_quit_button_clicked(GtkButton *button, gpointer user_data);
void on_quit_cancel_button_clicked(GtkButton *button, gpointer user_data);
void on_quit_button_clicked(GtkButton *button, gpointer user_data);
gboolean on_ifft_drawingarea_draw(GtkWidget *widget, cairo_t *cr, gpointer user_data);
gboolean on_qpsk_drawingarea_draw(GtkWidget *widget, cairo_t *cr, gpointer user_data);
void on_sdr_bw_entry_activate(GtkEntry *entry, gpointer user_data);
void on_sdr_freq_entry_activate(GtkEntry *entry, gpointer user_data);
gboolean on_sig_level_drawingarea_draw(GtkWidget *widget, cairo_t *cr, gpointer user_data);
gboolean on_sig_qual_drawingarea_draw(GtkWidget *widget, cairo_t *cr, gpointer user_data);
gboolean on_agc_gain_drawingarea_draw(GtkWidget *widget, cairo_t *cr, gpointer user_data);
gboolean on_pll_ave_drawingarea_draw(GtkWidget *widget, cairo_t *cr, gpointer user_data);
void on_sdr_gain_scale_value_changed(GtkRange *range, gpointer user_data);
void on_start_togglebutton_toggled(GtkToggleButton *togglebutton, gpointer user_data);
void on_manual_agc_radiobutton_toggled(GtkToggleButton *togglebutton, gpointer user_data);
void on_auto_agc_radiobutton_toggled(GtkToggleButton *togglebutton, gpointer user_data);

/*---------------------------------------------------------------------------*/

#endif

