/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef COMMON_H
#define COMMON_H    1

#include <gtk/gtk.h>

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

// Define GSourceOnceFunc if compiling against an older version of GLIB:
#if GLIB_VERSION_CUR_STABLE < G_ENCODE_VERSION(2,74)
  typedef void (* GSourceOnceFunc) (gpointer user_data);
#endif

#undef _Complex_I
#define _Complex_I  (__extension__ 1.0i)
#undef I
#define I _Complex_I

/* GNU/Hurd has no hard PATH_MAX */
#ifndef PATH_MAX
  #define PATH_MAX 4096
#endif

// Use __LOCATION__ anywhere you want the file and line number:
// (Move this to be used in all calls to Mem_Realloc)
#define __S1(x) #x
#define __S2(x) __S1(x)
#define __LOCATION__ __FILE__ ":"  __S2(__LINE__)

/*
 * Standard gettext macros.
 */
#ifdef ENABLE_NLS
#  include <libintl.h>
#  undef _
#  define _(String) dgettext (PACKAGE, String)
#  define Q_(String) g_strip_context ((String), gettext (String))
#  ifdef gettext_noop
#    define N_(String) gettext_noop (String)
#  else
#    define N_(String) (String)
#  endif
#else
#  define textdomain(String) (String)
#  define gettext(String) (String)
#  define dgettext(Domain,Message) (Message)
#  define dcgettext(Domain,Message,Type) (Message)
#  define bindtextdomain(Domain,Directory) (Domain)
#  define _(String) (String)
#  define Q_(String) g_strip_context ((String), (String))
#  define N_(String) (String)
#endif

/* commonly used complex constants */
#define CPLX_00 (0.0 + I * 0.0)
#define CPLX_01 (0.0 + I * 1.0)
#define CPLX_10 (1.0 + I * 0.0)
#define CPLX_11 (1.0 + I * 1.0)

#ifndef M_2PI
  #define M_2PI     6.28318530717958647692
#endif

/* common constants */
#define TORAD   1.745329252E-02
#define TODEG   57.29577951
#define ETA     376.73
#define CVEL    299.8
#define CONST1  (0.0 + I * 4.771341189)
#define CONST4  (0.0 + I * 188.365)
#define SMIN    1.0e-3

#define cmplx(r, i) ((r)+I*(i))

/* Replaces the "10000" limit used to */
/* identify segment/patch connections */
#define PCHCON  100000

/* Max length of a line read from input file */
#define LINE_LEN    135

/* Max length of strings used for creating file names */
#define FILENAME_LEN    256

/* Size of char arrays (strings) for error messages etc */
#define MESG_SIZE   128

/* Type of projection parameters struct */
#define STRUCTURE_DRAWINGAREA   1
#define RDPATTERN_DRAWINGAREA   2

/* Some colors for settinn cairo context */
#define WHITE   1.0, 1.0, 1.0
#define RED     1.0, 0.0, 0.0
#define YELLOW  1.0, 1.0, 0.0
#define GREEN   0.0, 1.0, 0.0
#define CYAN    0.0, 1.0, 1.0
#define BLUE    0.0, 0.0, 1.0
#define MAGENTA 1.0, 0.0, 1.0
#define GREY    0.5, 0.5, 0.5
#define BLACK   0.0, 0.0, 0.0

/* For read/write pipes */
#define READ    0
#define WRITE   1

/* Response to error dialog box */
#define ERR_OK      FALSE
#define ERR_STOP    TRUE

/*** Flow control flags ***/
/* Freq Loop Control flags */
#define FREQ_LOOP_RUNNING   0x0000000000000001ll
#define FREQ_LOOP_DONE      0x0000000000000002ll
#define FREQ_LOOP_INIT      0x0000000000000004ll
#define FREQ_LOOP_STOP      0x0000000000000008ll
#define FREQ_LOOP_FLAGS     0x000000000000000Fll

/* Main Window Control flags */
#define DRAW_CURRENTS       0x0000000000000010ll
#define DRAW_CHARGES        0x0000000000000020ll
#define COMMON_PROJECTION   0x0000000000000040ll
#define COMMON_FREQUENCY    0x0000000000000080ll
#define MAIN_NEW_FREQ       0x0000000000000100ll
#define MAIN_QUIT           0x0000000000000200ll

/* Freq Plot Control flags */
#define PLOT_ZREAL_ZIMAG    0x0000000000000400ll
#define PLOT_VSWR           0x0000000000000800ll
#define PLOT_ZMAG_ZPHASE    0x0000000000001000ll
#define PLOT_GMAX           0x0000000000002000ll
#define PLOT_GVIEWER        0x0000000000004000ll
#define PLOT_NETGAIN        0x0000000000008000ll
#define PLOT_GAIN_DIR       0x0000000000010000ll
#define PLOT_FREQ_LINE      0x0000000000020000ll
#define PLOT_SELECT         0x0000000000040000ll
#define PLOT_ENABLED        0x0000000000080000ll
#define PLOT_QUIT           0x0000000000100000ll
#define PLOT_SMITH          0x0000000000200000ll
#define PLOT_FLAGS          0x00400000003FFC00ll

/* Radiation Pattern Control flags */
#define DRAW_GAIN           0x0000000000400000ll
#define DRAW_EFIELD         0x0000000000800000ll
#define DRAW_HFIELD         0x0000000001000000ll
#define DRAW_EHFIELD        0x0000000002000000ll
#define DRAW_POYNTING       0x0000000004000000ll
#define DRAW_ENABLED        0x0000000008000000ll
#define DRAW_QUIT           0x0000000010000000ll
#define DRAW_NEW_RDPAT      0x0000000020000000ll
#define DRAW_NEW_EHFIELD    0x0000000040000000ll
#define OVERLAY_STRUCT      0x0000000080000000ll
#define NEAREH_SNAPSHOT     0x0000000100000000ll
#define NEAREH_ANIMATE      0x0000000200000000ll
#define ENABLE_RDPAT        0x0000000400000000ll
#define ENABLE_NEAREH       0x0000000800000000ll
#define DRAW_FLAGS          0x00000003FFC00000ll
#define RDPAT_FLAGS         0x0000000C00000000ll

/*** Filechooser response related flags ***/
#define NEC2_EDIT_SAVE      0x0000001000000000ll /* Save NEC2 editor data to a file */
#define NEC2_SAVE           0x0000002000000000ll /* Saving to a NEC2 input file */
#define IMAGE_SAVE          0x0000004000000000ll /* Struct/rad pattern/freq plots image save */
#define RDPAT_GNUPLOT_SAVE  0x0000008000000000ll /* Save rad pattern as gnuplot data */
#define PLOTS_GNUPLOT_SAVE  0x0000010000000000ll /* Save feq plots as gnuplot data */
#define STRUCT_GNUPLOT_SAVE 0x0000020000000000ll /* Save structure as gnuplot data */
#define OPEN_INPUT          0x0000040000000000ll /* Open a NEC2 input file flag */
#define OPEN_NEW_NEC2       0x0000080000000000ll /* Open a new NEC2 project flag */
#define ALL_CHOOSER_FLAGS   0x00000FF000000000ll

/* Other flags */
#define ERROR_CONDX         0x0000100000000000ll
#define INPUT_PENDING       0x0000200000000000ll
#define ENABLE_EXCITN       0x0000400000000000ll

/* Allocation control flags */
#define ALLOC_NEAREH_BUFF   0x0000800000000000ll
#define ALLOC_RDPAT_BUFF    0x0001000000000000ll
#define ALLOC_PNTING_BUFF   0x0002000000000000ll

/* Force editors to quit */
#define EDITOR_QUIT         0x0004000000000000ll

/* Frequency loop results ready */
#define FREQ_LOOP_READY     0x0008000000000000ll

/* Block motion events till ready */
#define BLOCK_MOTION_EV     0x0010000000000000ll

/* Indicate that an input file is open */
#define INPUT_OPENED        0x0020000000000000ll

/* Signal start of xnec2c */
#define XNEC2C_START        0x0040000000000000ll

// Enable Optimizer Output
#define OPTIMIZER_OUTPUT    0x0080000000000000ll

#define ALL_FLAGS           0xFFFFFFFFFFFFFFFFll

/* Type of near field data requested */
#define NEAR_EFIELD     0x01
#define NEAR_HFIELD     0x02
#define NEAR_EHFIELD    0x03

/* Gain Scaling style */
enum GAIN_SCALE
{
  GS_LINP = 0,
  GS_LINV,
  GS_ARRL,
  GS_LOG,
  NUM_SCALES
};

/* Polarization type */
enum POL_TYPE
{
  POL_TOTAL = 0,
  POL_HORIZ,
  POL_VERT,
  POL_RHCP,
  POL_LHCP,
  NUM_POL
};

enum
{
  MAIN_WINDOW = 1,
  FREQPLOTS_WINDOW,
  RDPATTERN_WINDOW
};

#endif
