/*
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 3 of
 *  the License, or (at your option) any later version.

 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details:
 *
 *  http://www.gnu.org/copyleft/gpl.txt
 */

#include "xplanet.h"
#include "shared.h"
#include "../common/common.h"
#include "../common/guest_utils.h"
#include "../common/utils.h"
#include <gtk/gtk.h>
#include <math.h>
#include <stdio.h>
#include <stdlib.h>

//------------------------------------------------------------------

/* Wspr_Display_Location
 *
 * Displays Home and Remote locations
 * and Great Circle arc using xplanet
 */
  void
Wspr_Display_Location( int n_results )
{
  double
    home_lat,   home_long,     // Home latitude and longitude
    remote_lat, remote_long;   // Remote latitude and longitude

  /* Open xplanet file descriptors */
  FILE *config_fd   = fopen( wspr_rc.xplanet_config_file, "w" );
  FILE *marker_fd   = fopen( wspr_rc.xplanet_marker_file, "w" );
  FILE *greatarc_fd = fopen( wspr_rc.xplanet_arc_file,    "w" );
  if( (config_fd   == NULL) ||
      (marker_fd   == NULL) ||
      (greatarc_fd == NULL) )
  {
    if( config_fd   != NULL ) Close_File( &config_fd );
    if( greatarc_fd != NULL ) Close_File( &greatarc_fd );
    if( marker_fd   != NULL ) Close_File( &marker_fd );
    perror( "hermes2-wspr: fopen()" );
    Set_Label_Text( wspr_gui.wspr_status_label, "Failed to open xplanet files" );
    return;
  }

  /* Setup config file */
  fprintf( config_fd, "arc_file=%s\nmarker_file=%s\n",
      wspr_rc.xplanet_arc_file, wspr_rc.xplanet_marker_file );

  // Calculate "Home" position
  Gridloc_to_Position( wspr_rc.decoder_options.rx_loc, &home_lat, &home_long );

  /* Enter "Home" station's position in marker file */
  fprintf( marker_fd, "%8.3f %8.3f \"%s\" %s\n",
      home_lat, home_long, wspr_rc.home_name, "color=red" );

  for( int idx = 0; idx < n_results; idx++ )
  {
    // Cannot display if remote locator not known
    if( strncmp(decoder_results[idx].loc, "XXXX", 4) == 0 )
      continue;

    // Calculate "Remote" station's position
    Gridloc_to_Position( decoder_results[idx].loc, &remote_lat, &remote_long );

    /* Enter "Remote" position in marker file */
    fprintf( marker_fd, "%8.3f %8.3f \"%s\" %s\n",
        remote_lat, remote_long, decoder_results[idx].call,
        "color=yellow" );

    /* Enter Home/Remote positions in greatarc file */
    fprintf( greatarc_fd, "%8.3f %8.3f %8.3f %8.3f %s\n",
        home_lat, home_long, remote_lat, remote_long, "color=yellow" );
  } // for( int idx = 0; idx < n_results; idx++ )

  // Close files and launch xplanet
  Close_File( &config_fd );
  Close_File( &greatarc_fd );
  Close_File( &marker_fd );
  Launch_Xplanet( wspr_rc.xplanet_command );

  return;
} /* End of Wspr_Display_Location() */

/*------------------------------------------------------------------------*/

