/*
  This file is part of program wsprd, a detector/demodulator/decoder
  for the Weak Signal Propagation Reporter (WSPR) mode.

  File name: wsprd.c

  Copyright 2001-2015, Joe Taylor, K1JT

  Much of the present code is based on work by Steven Franke, K9AN,
  which in turn was based on earlier work by K1JT.

  Copyright 2014-2015, Steven Franke, K9AN

  Minor modifications

  Copyright 2016, Guenael Jouchet, VA2GKA

  License: GNU GPL v3

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef WSPRD_H
#define WSPRD_H   1

#include "shared.h"
#include <stdint.h>

struct cand
{
  double freq;
  double snr;
  int    shift;
  double drift;
  double sync;
};

/* wsprd.c */
void Sync_And_Demodulate(const double *id, const double *qd, long np, unsigned char *symbols, double *freq, int ifmin, int ifmax, double fstep, int *shift, int lagmin, int lagmax, int lagstep, const double *drift, int symfac, double *sync, int mode);
void Subtract_Signal(double *id, double *qd, long np, double f0, int shift, double drift, const unsigned char *channel_symbols);
void Subtract_Signal2(double *id, double *qd, long np, double f0, int shift, double drift, const unsigned char *channel_symbols);
int Wspr_Decode(double *idat, double *qdat, int samples, decoder_results_t *decodes, int16_t *n_results);
void Free_Wspr_Decoder(void);

#endif

