/*
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 2 of
 *  the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details:
 *
 *  http://www.gnu.org/copyleft/gpl.txt
 */

#ifndef WSPR_SHARED_H
#define WSPR_SHARED_H   1

#include "../common/common.h"
#include "../common/guest_utils.h"
#include <gtk/gtk.h>

// Sizes of strings
#define CALL_SIZE           13
#define LOC_SIZE            7
#define PWR_SIZE            3
#define MESSAGE_SIZE        23
#define CALL_LOC_POW_SIZE   23

// FFT parameters
#define FFT_IO_SIZE         512    // Size of FFT Input and Output buffers
#define FFT_ORDER           9      // Order of FFT

// Sampling parameters
#define SIGNAL_LENGTH       120    // Length of WSPR signal in seconds
#define SAMPLES_BUF_SIZE    45000  // SIGNAL_LENGTH * SIGNAL_SAMPLE_RATE
#define SIGNAL_SAMPLES      45000  // SIGNAL_LENGTH * SIGNAL_SAMPLE_RATE
#define DOWNSAMPLING        128    // SAMPLING_RATE / SIGNAL_SAMPLE_RATE
#define SIGNAL_SAMPLE_RATE  375    // Signal sampling rate after downsampling

// Option & config of decoder (Shared with the wsprd code)
typedef struct _DECODER_OPTIONS
{
  uint32_t center_freq;    // Current Center frequency
  uint32_t new_freq;       // New Center frequency selected
  BOOLEAN  quick_mode;     // Decoder option & tweak
  BOOLEAN  use_hashtable;  //  ''
  uint8_t  npasses;        //  ''
  BOOLEAN  subtraction;    //  ''
  char     rx_call[CALL_SIZE]; // Callsign of the RX station
  char     rx_loc[LOC_SIZE];   // Locator of the RX station
} decoder_options_t;

// WSPR decoder's results
typedef struct _DECODER_RESULTS
{
  double freq;
  double sync;
  double snr;
  double dt;
  double drift;
  int    jitter;
  char   message[MESSAGE_SIZE];
  char   call[CALL_SIZE];
  char   loc[LOC_SIZE];
  char   pwr[PWR_SIZE];
  int    cycles;
} decoder_results_t;

#define DEC_RESULTS_SIZE    50
extern decoder_results_t decoder_results[DEC_RESULTS_SIZE];

typedef struct _WSPR_RC
{
  // WSPR working directory
  char wspr_dir[FILE_NAME_SIZE];

  // Xplanet config files
  char
    xplanet_command[XPLANET_CMND_SIZE],
    xplanet_options[FILE_NAME_SIZE],
    xplanet_config_file[FILE_NAME_SIZE],
    xplanet_marker_file[FILE_NAME_SIZE],
    xplanet_arc_file[FILE_NAME_SIZE];

  // Home location data
  char home_name[32];

  // WSPR decoder options
  decoder_options_t decoder_options;

  BOOLEAN
    post,     // Post WSPR results to wsprnet.org
    xplanet;  // Enable xplanet display

} wspr_rc_t;

// Runtime config data
extern wspr_rc_t wspr_rc;

// Wspr GUI data
typedef struct _WSPR_GUI
{
  GtkWidget
    *window,              // WSPR's main window
    *bands_combobox,      // WSPR bands selection combobox
    *text_view,           // WSPR spots text viewer
    *post_checkbutton,    // WSPR Post Results checkbutton
    *xplanet_checkbutton, // WSPR Enable Xplanet Display checkbutton
    *scroller;            // WSPR text view text buffer

  // WSPR text view text buffer
  GtkTextBuffer *text_buffer;
  GtkTextIter text_buffer_iter;

  // Displays the current status of WSPR decoder
  GtkLabel *wspr_status_label;

  // Gtk builders for some above that need to be global
  GtkBuilder *builder;

} wspr_gui_t;

extern wspr_gui_t wspr_gui;

// Receiver State & Options
typedef struct _RECEIVER_STATE
{
  /* Variables used for stop conditions */
  BOOLEAN exit_flag, run_flag, decoder_flag;

  /* Double buffering used for sampling */
  double iSamples[2][SAMPLES_BUF_SIZE];
  double qSamples[2][SAMPLES_BUF_SIZE];

  /* Sample index */
  uint32_t iqIndex[2];

  /* Buffer selected (0 or 1) */
  uint8_t bufferIndex;

  /* Time at the beginning of the frame to decode */
  struct tm *gmt;

} receiver_state_t;

extern receiver_state_t rx_state;

/* Thread for decoding */
typedef struct _DECODER_STATE
{
  pthread_t        thread;
  pthread_attr_t   tattr;
} decoder_state_t;

extern decoder_state_t decState;

#endif

