/*
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 3 of
 *  the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details:
 *
 *  http://www.gnu.org/copyleft/gpl.txt
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include "interface.h"
#include "shared.h"
#include "utils.h"
#include "whisper.h"
#include "../common/common.h"
#include "../common/shared.h"
#include "../common/utils.h"
#include <gtk/gtk.h>
#include <stdlib.h>

//------------------------------------------------------------------

#define WSPR_WINDOW_IDS \
  "wspr_window", \
  NULL

//------------------------------------------------------------------

static gchar wspr_glade[FILE_NAME_SIZE];

/* Create_Wspr_Window()
 *
 * Creates the main WSPR window
 */
  GtkWidget *
Create_Wspr_Window( GtkBuilder **builder )
{
  gchar *object_ids[] = { WSPR_WINDOW_IDS };

  // Setup file path to WSPR working directory
  Strlcpy( wspr_rc.wspr_dir, getenv("HOME"),   sizeof(wspr_rc.wspr_dir) );
  Strlcat( wspr_rc.wspr_dir, "/.hermes2/wspr/", sizeof(wspr_rc.wspr_dir) );
  Strlcpy( wspr_glade, wspr_rc.wspr_dir, sizeof(wspr_glade) ) ;
  Strlcat( wspr_glade, "wspr.glade",     sizeof(wspr_glade) ) ;

  Gtk_Builder( builder, wspr_glade, object_ids );
  wspr_gui.window = Builder_Get_Object( *builder, "wspr_window" );
  gtk_widget_show( wspr_gui.window );
  hermes2_gui.guest_window = wspr_gui.window;

  // Get Text buffer and scroller
  wspr_gui.text_view = Builder_Get_Object( *builder, "wspr_textview" );
  wspr_gui.text_buffer = gtk_text_view_get_buffer(
      GTK_TEXT_VIEW(Builder_Get_Object(*builder, "wspr_textview")) );
  wspr_gui.scroller = Builder_Get_Object( *builder, "wspr_scroller" );

  // Get bands combobox
  wspr_gui.bands_combobox =
    Builder_Get_Object( *builder, "wspr_bands_combobox" );

  // Get Post Results flag
  wspr_gui.post_checkbutton =
    Builder_Get_Object( *builder, "wspr_post_checkbutton" );

  // Get Enable Xplanet flag
  wspr_gui.xplanet_checkbutton =
    Builder_Get_Object( *builder, "wspr_xplanet_checkbutton" );

  // Get status label
  wspr_gui.wspr_status_label =
    GTK_LABEL( Builder_Get_Object( *builder, "wspr_status_label") );

  // Signal function to initialize
  static int16_t flag = -1;
  g_idle_add( Print_Spots, (gpointer)&flag  );

  // Read the configuration file
  g_idle_add( Wspr_Read_Config, NULL );

  rx_state.decoder_flag = False;
  rx_state.exit_flag    = False;
  rx_state.run_flag     = False;

  return( wspr_gui.window );
} // Create_Wspr_Window()

//------------------------------------------------------------------

