/*
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 3 of
 *  the License, or (at your option) any later version.

 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details:
 *
 *  http://www.gnu.org/copyleft/gpl.txt
 */

#include "callbacks.h"
#include "whisper.h"
#include "shared.h"
#include "utils.h"
#include "wsprd.h"
#include "../common/guest_utils.h"
#include "../common/shared.h"
#include <gtk/gtk.h>

//------------------------------------------------------------------

// All callback functions of the WSPR client

  void
on_wspr_window_destroy(
    GObject  *object,
    gpointer  user_data )
{
  rx_state.exit_flag = TRUE;

  // Wait for Rx mode and decoder to exit
  if( Flag[GUEST_RECEIVING] )
    pthread_join( hermes2_rc.guest_rx_thread, NULL );
  if( Flag[WSPR_DECODER_THREAD] )
    pthread_join( decState.thread, NULL );

  if( !rx_state.run_flag ) Wspr_Cleanup();

  // Close GUI objects
  g_object_unref( wspr_gui.builder );
  wspr_gui.builder = NULL;
  wspr_gui.window  = NULL;
  hermes2_gui.guest_window = NULL;

  // Kill xplanet and remove files
  if( wspr_rc.xplanet )
    Kill_Xplanet(
        wspr_rc.xplanet_config_file,
        wspr_rc.xplanet_marker_file,
        wspr_rc.xplanet_arc_file );
  wspr_rc.xplanet = False;
}

//------------------------------------------------------------------

  gboolean
on_wspr_window_delete(
    GtkWidget *widget,
    GdkEvent  *event,
    gpointer   user_data )
{
  // Save current config
  Wspr_Write_Config();
  rx_state.exit_flag = TRUE;

  // Wait for Rx mode and decoder to exit
  if( Flag[GUEST_RECEIVING] )
    pthread_join( hermes2_rc.guest_rx_thread, NULL );
  if( Flag[WSPR_DECODER_THREAD] )
    pthread_join( decState.thread, NULL );

  Guest_Quit_Activate( wspr_gui.window );
  return( TRUE );
}

//------------------------------------------------------------------

  void
on_wspr_quit_button_clicked(
    GtkButton  *button,
    gpointer    user_data )
{
  // Save current config
  Wspr_Write_Config();
  rx_state.exit_flag = TRUE;
  Guest_Quit_Activate( wspr_gui.window );
}

//------------------------------------------------------------------

  void
on_wspr_clear_button_clicked(
    GtkButton  *button,
    gpointer    user_data )
{
  gtk_text_buffer_set_text( wspr_gui.text_buffer, "", -1 );
  gtk_text_buffer_get_iter_at_offset(
      wspr_gui.text_buffer, &wspr_gui.text_buffer_iter,
      gtk_text_buffer_get_char_count(wspr_gui.text_buffer) );
}

//------------------------------------------------------------------

  void
on_wspr_start_togglebutton_toggled(
    GtkToggleButton *togglebutton,
    gpointer         user_data )
{
  Wspr_Start( togglebutton );
}

//------------------------------------------------------------------

  void
on_wspr_bands_combobox_changed(
    GtkComboBoxText  *combobox,
    gpointer          user_data )
{
  Wspr_Bands_Combobox_Changed( combobox );
}

//------------------------------------------------------------------

  void
on_wspr_post_toggled(
    GtkToggleButton *togglebutton,
    gpointer         user_data )
{
  if( gtk_toggle_button_get_active(togglebutton) )
    wspr_rc.post = True;
  else
    wspr_rc.post = False;
}

//------------------------------------------------------------------

  void
on_wspr_xplanet_toggled(
    GtkToggleButton *togglebutton,
    gpointer         user_data )
{
  if( gtk_toggle_button_get_active(togglebutton) )
    wspr_rc.xplanet = True;
  else
  {
    // Kill xplanet and remove files
    if( wspr_rc.xplanet )
      Kill_Xplanet(
          wspr_rc.xplanet_config_file,
          wspr_rc.xplanet_marker_file,
          wspr_rc.xplanet_arc_file );
    wspr_rc.xplanet = False;
  }
}

//------------------------------------------------------------------

