/*
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 2 of
 *  the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details:
 *
 *  http://www.gnu.org/copyleft/gpl.txt
 */

#ifndef WEFAX_UTILS_H
#define WEFAX_UTILS_H   1

#include "../common/common.h"
#include <gtk/gtk.h>
#include <stdio.h>
#include <stdint.h>

//------------------------------------------------------------------

// Choices of RPM values in menu
#define RPM60       60
#define RPM90       90
#define RPM100      100
#define RPM120      120
#define RPM180      180
#define RPM240      240
#define NUM_RPM     6

//------------------------------------------------------------------

// Choices of Pix/line values in menu
#define PIX600      600
#define PIX1200     1200
#define NUM_PIX     2

//------------------------------------------------------------------

// Choices of IOC values in menu
#define IOC288      288
#define IOC576      576
#define NUM_IOC     2

//------------------------------------------------------------------

// Choices of number Phasing lines in menu
#define PHL10       10
#define PHL20       20
#define PHL40       40
#define PHL60       60
#define NUM_PHL     4

//------------------------------------------------------------------

// Choices of image enhancement algorithm
enum
{
  IME0 = 0,
  IME1,
  IME2,
  NUM_IME
};

//------------------------------------------------------------------

// utils.c
gboolean Wefax_Read_Config(gpointer data);
void New_Lines_Per_Min(void);
void New_Pixels_Per_Line(void);
void New_IOC(void);
void New_Phasing_Lines(void);
void New_Image_Enhance(void);
void Wefax_Configure(void);
void Wefax_File_Name(char *file_name, const char *extn);
BOOLEAN Wefax_Save_Image_PGM(FILE **fp, const char *type, uint16_t width, uint16_t height, uint16_t max_val, const uint8_t *buffer);
BOOLEAN Wefax_Save_Image_JPEG(FILE **fp, int width, int height, const uint8_t *buffer);
void Wefax_Show_Message(char *mesg, char *attr);

#endif

