/*
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 2 of
 *  the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details:
 *
 *  http://www.gnu.org/copyleft/gpl.txt
 */

#ifndef WEFAX_SHARED_H
#define WEFAX_SHARED_H   1

#include "common.h"
#include "../common/ifft.h"
#include "../common/guest_utils.h"
#include <gtk/gtk.h>

#define PIXBUF_BACKGND  0xb0b0b0ff


// Runtime config data
typedef struct _WEFAX_RC
{
  // Wefax working directory, RC file path and bookmarks file
  char
    wefax_dir[FILE_NAME_SIZE],
    rc_fpath[FILE_NAME_SIZE],
    bookmarks_file[FILE_NAME_SIZE],
    station_sideband[4];

    // Set default widow height
    uint16_t window_height;

    uint16_t
      image_lines,        // Maximum number of lines to decode
      pixels_per_line,    // Image resolution pixels/line
      pixels_per_line2,   // Image resolution pixels/line / 2
      stop_tone,          // WEFAX stop tone, normally 450 Hz
      start_tone,         // WEFAX start tone, depends on IOC value
      ioc_value;          // IOC value specified in wefaxrc

    // Size of buffer for the pixels of 2 lines
    uint16_t line_buffer_size;

    // Number of phasing pulse lines to use for sync
    uint8_t phasing_lines;

    double
    pixel_len,          // Duration of a pixel in DSP samples
    lines_per_min,      // Line transmission rate
    sync_slant,         // Difference in scan speed in pix/line
    start_tone_period,  // Period of start tone in DSP samples
    stop_tone_period;   // Period of stop tone in DSP samples

  // Initialization flags
  BOOLEAN
    gui_init,
    mesg_init,
    icon_init,
    gauge_init;

  uint8_t image_enhance;

} wefax_rc_t;

// Runtime config data
extern wefax_rc_t wefax_rc;

// Wefax image display data
typedef struct _WEFAX_DISPLAY
{
  // Pixel buffer for display
  guchar    *pixel_buf;
  GdkPixbuf *pixbuf;
  gint rowstride, n_channels;

  // Buffer for pixels of one image line
  uint8_t *line_buffer;
  uint16_t line_count;
  int linebuff_input, linebuff_output;

} wefax_display_t;

extern wefax_display_t wefax_display;

// Wefax GUI data
typedef struct _WEFAX_GUI
{
  GtkWidget
    *window,               // wefax's top window
    *start_icon,           // Waiting for Start signal indicator
    *sync_icon,            // Waiting for Sync signal indicator
    *decode_icon,          // Decoder running indicator
    *save_icon,            // Save Image enabled indicator
    *bmk_window,           // Stations list window
    *popup_menu,           // Popup main menu
    *scope_drawingarea,    // Signal scope widget
    *spectrum_drawingarea, // Signal spectrum widget
    *level_gauge,          // The vertical level gauge in control frame
    *drawingarea;          // Drawingarea to display WEFAX image

  // Tree list store
  GtkListStore *bmk_list_store;
  GtkTreeView  *bmk_treeview;

  // Gtk builders for some above that need to be global
  GtkBuilder
    *popup_menu_builder,
    *bmk_window_builder,
    *window_builder;

  // Text buffer for text view
  GtkTextView   *text_view;
  GtkTextBuffer *text_buffer;

} wefax_gui_t;

extern wefax_gui_t wefax_gui;

// Pixbuffer for waterfall
extern pixbuffer_t wefax_wfall;

// Signal scope size
extern uint16_t wefax_scope_width, wefax_scope_height;

// Values needed to plot the level gauge
extern int32_t gauge_input, gauge_level1, gauge_level2;

// What action the WEFAX decoder should enter
extern uint8_t wefax_action;

// Fm Detector function pointer
extern BOOLEAN ( *FM_Detector ) ( uint8_t *level );

extern ifft_data_t wefax_ifft_data;

#endif

