/*
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 2 of
 *  the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details:
 *
 *  http://www.gnu.org/copyleft/gpl.txt
 */

#include "shared.h"
#include "common.h"
#include "../common/ifft.h"
#include "../common/guest_utils.h"
#include <gtk/gtk.h>
#include <stdint.h>
#include <stdlib.h>

// Runtime config data
wefax_rc_t wefax_rc;

// Wefax image display data
wefax_display_t wefax_display;

// Wefax GUI data
wefax_gui_t wefax_gui;

// Pixbuffer for waterfall
pixbuffer_t wefax_wfall;

// Signal scope size
uint16_t wefax_scope_width, wefax_scope_height;

// Values needed to plot the level gauge
int32_t
  gauge_input  = -1,
  gauge_level1 = 1,
  gauge_level2 = 1;

// What action the WEFAX decoder should enter
uint8_t wefax_action = WEFAX_ACTION_STOP;

// Fm Detector function pointer
BOOLEAN ( *FM_Detector ) ( uint8_t *level ) = NULL;

ifft_data_t wefax_ifft_data;

//------------------------------------------------------------------

