/*
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 3 of
 *  the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details:
 *
 *  http://www.gnu.org/copyleft/gpl.txt
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include "display.h"
#include "interface.h"
#include "shared.h"
#include "utils.h"
#include "../common/common.h"
#include "../common/shared.h"
#include "../common/utils.h"
#include <gtk/gtk.h>
#include <stdint.h>
#include <stdio.h>
#include <stdlib.h>

//------------------------------------------------------------------

#define WEFAX_POPUP_MENU_IDS \
  "wefax_menu", \
  NULL

//------------------------------------------------------------------

#define WEFAX_WINDOW_IDS \
  "wefax_window", \
  "slant_align", \
  NULL

//------------------------------------------------------------------

#define WEFAX_STATIONS_WINDOW_IDS \
  "wefax_bmk_window", \
  NULL

//------------------------------------------------------------------

#define WEFAX_GLADE_FILE "/.hermes2/wefax/wefax.glade"
static gchar wefax_glade[FILE_NAME_SIZE];

/* Create_Wefax_Window()
 *
 * Creates the main Wefax window
 */
  GtkWidget *
Create_Wefax_Window( GtkBuilder **builder )
{
  gchar *object_ids[] = { WEFAX_WINDOW_IDS };
  Strlcpy( wefax_glade, getenv("HOME"), sizeof(wefax_glade) );
  Strlcat( wefax_glade, WEFAX_GLADE_FILE, sizeof(wefax_glade) );
  Gtk_Builder( builder, wefax_glade, object_ids );
  wefax_gui.window = Builder_Get_Object( *builder, "wefax_window" );
  gtk_widget_show( wefax_gui.window );

  // Signal (Re)-initialization of Wefax
  wefax_rc.gui_init   = True;
  wefax_rc.mesg_init  = True;
  wefax_rc.gauge_init = True;

  // Get scope widgets
  wefax_gui.scope_drawingarea =
    Builder_Get_Object( wefax_gui.window_builder, "wefax_scope_drawingarea" );
  wefax_gui.spectrum_drawingarea =
    Builder_Get_Object( wefax_gui.window_builder, "wefax_spectrum_drawingarea" );

  // Get the status indicator icons
  wefax_gui.start_icon  =
    Builder_Get_Object( wefax_gui.window_builder, "wefax_start_icon" );
  wefax_gui.sync_icon   =
    Builder_Get_Object( wefax_gui.window_builder, "wefax_sync_icon" );
  wefax_gui.decode_icon =
    Builder_Get_Object( wefax_gui.window_builder, "wefax_decode_icon" );
  wefax_gui.save_icon   =
    Builder_Get_Object( wefax_gui.window_builder, "wefax_save_icon" );
    wefax_gui.level_gauge =
      Builder_Get_Object( wefax_gui.window_builder, "wefax_gauge_drawingarea" );

  // Get sizes of displays
  GtkAllocation alloc;
  gtk_widget_get_allocation( wefax_gui.scope_drawingarea, &alloc );
  wefax_scope_width  = (uint16_t)alloc.width;
  wefax_scope_height = (uint16_t)alloc.height;
  gtk_widget_get_allocation( wefax_gui.spectrum_drawingarea, &alloc );
  Wefax_Spectrum_Size_Allocate( (uint16_t)alloc.width, (uint16_t)alloc.height );

  // Get text buffer and viewer
  wefax_gui.text_view =
    GTK_TEXT_VIEW( Builder_Get_Object(wefax_gui.window_builder, "wefax_textview") );
  wefax_gui.text_buffer = gtk_text_view_get_buffer( wefax_gui.text_view );

  // Create the popup menu to set it up
  wefax_gui.popup_menu = Create_Wefax_Menu( &wefax_gui.popup_menu_builder );

  // Create some rendering tags
  gtk_text_buffer_create_tag( wefax_gui.text_buffer, "red",
      "foreground", "red", NULL);
  gtk_text_buffer_create_tag( wefax_gui.text_buffer, "orange",
      "foreground", "orange", NULL);
  gtk_text_buffer_create_tag( wefax_gui.text_buffer, "green",
      "foreground", "green", NULL);
  gtk_text_buffer_create_tag( wefax_gui.text_buffer, "bold",
      "weight", PANGO_WEIGHT_BOLD, NULL);

  // Make a label for the start button
  GtkLabel *label = GTK_LABEL(
      Builder_Get_Object(wefax_gui.window_builder, "rcve_status") );
  gtk_label_set_width_chars( label, 9 );
  gtk_label_set_text ( label, _(" STANDBY ") );

  // Clear image file name
  wefax_rc.sync_slant = 0.0;

  // Print greeting message
  char ver[24];

  snprintf( ver, sizeof(ver), _("Welcome to %s"), PACKAGE_STRING );
  Wefax_Show_Message( ver, "bold" );
  Flag[WEFAX_RECEIVE_STOP]   = True;
  Flag[WEFAX_SAVE_IMAGE_JPG] = True;
  Flag[WEFAX_SAVE_IMAGE]     = True;
  Wefax_Set_Indicators( WEFAX_ICON_SAVE_YES );

  // Load runtie config file, abort on error
  g_idle_add( Wefax_Read_Config, NULL );
  while( g_main_context_iteration(NULL, FALSE) );

  return( wefax_gui.window );
} // Create_Wefax_Window()

//------------------------------------------------------------------

/* Create_Wefax_Menu()
 *
 * Creates the Wefax popup menu
 */
  GtkWidget *
Create_Wefax_Menu( GtkBuilder **builder )
{
  gchar *object_ids[] = { WEFAX_POPUP_MENU_IDS };
  Gtk_Builder( builder, wefax_glade, object_ids );
  GtkWidget *menu = Builder_Get_Object( *builder, "wefax_menu" );
  return( menu );
} // Create_Wefax_Menu()

//------------------------------------------------------------------

/* Create_Wefax_Bmk_Window()
 *
 * Creates the Wefax Boonmarks window
 */
  GtkWidget *
Create_Wefax_Bmk_Window( GtkBuilder **builder )
{
  gchar *object_ids[] = { WEFAX_STATIONS_WINDOW_IDS };
  Gtk_Builder( builder, wefax_glade, object_ids );
  GtkWidget *window = Builder_Get_Object( *builder, "wefax_bmk_window" );
  return( window );
} // Create_Wefax_Bmk_Window()

//------------------------------------------------------------------

