/*
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 2 of
 *  the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details:
 *
 *  http://www.gnu.org/copyleft/gpl.txt
 */

#ifndef WEFAX_DISPLAY_H
#define WEFAX_DISPLAY_H   1

#include <cairo/cairo.h>
#include <stdint.h>

//------------------------------------------------------------------

#define WEFAX_WHITE_FREQ     2300
#define WEFAX_BLACK_FREQ     1500

//------------------------------------------------------------------------

// display.c
void Wefax_Display_Signal(uint8_t plot);
void Wefax_Display_Waterfall(void);
void Wefax_Draw_Signal(cairo_t *cr);
void Wefax_Free_Display(void);
void Wefax_Set_Indicators(uint8_t flag);
void Wefax_Set_Menu_Items(void);
void Normalize(uint8_t *line_buf, uint32_t line_len);
void Wefax_Spectrum_Size_Allocate(uint16_t width, uint16_t height);
void Set_Sync_Slant(double sync_slant);
void Wefax_Display_Level_Gauge(cairo_t *cr);
void Wefax_Tune_TRx(double x);

#endif

