/*
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 2 of
 *  the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details:
 *
 *  http://www.gnu.org/copyleft/gpl.txt
 */

#ifndef WEFAX_DETECT_H
#define WEFAX_DETECT_H   1

#include "../common/common.h"
#include <stdint.h>

// detect.c
BOOLEAN FM_Detect_IQ(uint8_t *signal_level);
BOOLEAN FM_Detect_Zero_Crossing(uint8_t *signal_level);
BOOLEAN FM_Detect_Bilevel(uint8_t *signal_level);
void Wefax_Free_Detect(void);
BOOLEAN Phasing_Detect(void);
BOOLEAN Start_Tone_Detect(void);
BOOLEAN Stop_Tone_Detect(uint8_t discr_op);

#endif

