/*
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 2 of
 *  the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details:
 *
 *  http://www.gnu.org/copyleft/gpl.txt
 */

#ifndef WEFAX_COMMON_H
#define WEFAX_COMMON_H   1

#include "../common/common.h"
#include <stdint.h>

// WEFAX start/stop tones
#define IOC576_START_TONE   300
#define IOC288_START_TONE   675
#define WEFAX_STOP_TONE     450

// Length of phasing pulse in pixels
#define WEFAX_PHASING_PULSE_SIZE   55

// Length of phasing pulse sliding window
#define WEFAX_PHASING_PUSLE_WIN   32.0

// Wefax control flags
enum
{
  WEFAX_ACTION_BEGIN = 1, // Begin the WEFAX Image decoding process
  WEFAX_ACTION_START,     // Look for the WEFAX Start tone
  WEFAX_ACTION_PHASING,   // Sync with the WEFAX phasing pulse
  WEFAX_ACTION_DECODE,    // Decode the WEFAX image
  WEFAX_ACTION_STOP       // Stop operations
};

// Status Indicator Icons
enum
{
  WEFAX_ICON_START_YES = 1,
  WEFAX_ICON_SYNC_YES,
  WEFAX_ICON_DECODE_YES,
  WEFAX_ICON_SAVE_YES,
  WEFAX_ICON_START_NO,
  WEFAX_ICON_SYNC_NO,
  WEFAX_ICON_DECODE_NO,
  WEFAX_ICON_SAVE_NO,
  WEFAX_ICON_START_SKIP,
  WEFAX_ICON_SYNC_SKIP,
  WEFAX_ICON_DECODE_SKIP,
  WEFAX_ICON_SAVE_SKIP,
  WEFAX_ICON_START_APPLY,
  WEFAX_ICON_SYNC_APPLY,
  WEFAX_ICON_DECODE_APPLY,
  WEFAX_ICON_SAVE_APPLY
};

#endif

