/*
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 3 of
 *  the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details:
 *
 *  http://www.gnu.org/copyleft/gpl.txt
 */

#ifndef WEFAX_CALLBACKS_H
#define WEFAX_CALLBACKS_H   1

#include <cairo/cairo.h>
#include <gtk/gtk.h>

// callbacks.c
gboolean on_wefax_window_delete(GtkWidget *widget, GdkEvent *event, gpointer user_data);
void on_wefax_window_destroy(GObject *object, gpointer user_data);
void on_wefax_scope_drawingarea_configure(GtkWidget *widget, GdkEventConfigure *event, gpointer user_data);
void on_wefax_spectrum_drawingarea_configure(GtkWidget *widget, const GdkEventConfigure *event, gpointer user_data);
gboolean on_wefax_spectrum_drawingarea_draw(GtkWidget *widget, cairo_t *cr, gpointer user_data);
gboolean on_wefax_spectrum_button_press(GtkWidget *widget, const GdkEventButton *event, gpointer user_data);
gboolean on_wefax_scope_drawingarea_draw(GtkWidget *widget, cairo_t *cr, gpointer user_data);
void on_wefax_start_togglebutton_toggled(GtkToggleButton *togglebutton, gpointer user_data);
void on_wefax_skip_button_clicked(GtkButton *button, gpointer user_data);
void on_wefax_rpm_activate(GtkMenuItem *menuitem, gpointer user_data);
void on_wefax_pix_activate(GtkMenuItem *menuitem, gpointer user_data);
void on_wefax_ioc_activate(GtkMenuItem *menuitem, gpointer user_data);
void on_wefax_phl_activate(GtkMenuItem *menuitem, gpointer user_data);
void on_wefax_enhance_activate(GtkMenuItem *menuitem, gpointer user_data);
void on_wefax_deslant_spinbutton_value_changed(GtkSpinButton *spinbutton, gpointer user_data);
void on_wefax_in_image_phasing_activate(GtkMenuItem *menuitem, gpointer user_data);
gboolean on_wefax_drawingarea_button_press(GtkWidget *widget, const GdkEventButton *event, gpointer user_data);
gboolean on_wefax_drawingarea_draw(GtkWidget *widget, cairo_t *cr, gpointer user_data);
void on_wefax_bmk_activate(GtkMenuItem *menuitem, gpointer user_data);
void on_wefax_bmk_window_destroy(GObject *object, gpointer user_data);
void on_wefax_down_button_clicked(GtkButton *button, gpointer user_data);
void on_wefax_up_button_clicked(GtkButton *button, gpointer user_data);
void on_wefax_save_button_clicked(GtkButton *button, gpointer user_data);
void on_wefax_delete_button_clicked(GtkButton *button, gpointer user_data);
void on_wefax_new_button_clicked(GtkButton *button, gpointer user_data);
void on_wefax_bmk_treeview_cursor_changed(GtkTreeView *treeview, gpointer user_data);
gboolean on_wefax_bmk_treeview_button_press(GtkWidget *widget, const GdkEventButton *event, gpointer user_data);
void on_wefax_jpeg_activate(GtkMenuItem *menuitem, gpointer user_data);
void on_wefax_pgm_activate(GtkMenuItem *menuitem, gpointer user_data);
void on_wefax_both_activate(GtkMenuItem *menuitem, gpointer user_data);
void on_wefax_iqdetect_activate(GtkMenuItem *menuitem, gpointer user_data);
void on_wefax_zerocross_activate(GtkMenuItem *menuitem, gpointer user_data);
void on_wefax_bilevel_activate(GtkMenuItem *menuitem, gpointer user_data);
gboolean on_wefax_gauge_drawingarea_draw(GtkWidget *widget, cairo_t *cr, gpointer user_data);
void on_wefax_save_checkbutton_toggled(GtkToggleButton *togglebutton, gpointer user_data);

#endif

