/*
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 2 of
 *  the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details:
 *
 *  http://www.gnu.org/copyleft/gpl.txt
 */

#ifndef TIME_SIGNAL_H
#define TIME_SIGNAL_H   1

#include "../common/transceiver.h"
#include <stdint.h>
#include <time.h>

//------------------------------------------------------------------------

// Data used for decoding and display of Date/Time
typedef struct _TIMETX_DATA
{
  // Time station and decoded data bits
  uint8_t station, data_bit_1, data_bit_2;

  /* Current second of time, truncated
   * Julian day, DeltaUT and return status */
  int second, tjd, DUT, status;

  // Current DUT1 value
  double DUT1;

  // Current decoded time
  struct tm tim;

} time_data_t;

//------------------------------------------------------------------------

// Time station index
enum TIME_TX_IDX
{
  NONE = 0,
  MSF60,
  RBU66,
  DCF77,
  ALL162
};

//------------------------------------------------------------------------

// Error and Message Flags to return
#define HOUR_ERROR          0x000001
#define MINUTE_ERROR        0x000002
#define DATE_ERROR          0x000004
#define YEAR_ERROR          0x000008
#define MONTH_ERROR         0x000010
#define MDAY_ERROR          0x000020
#define RBU66_DUT_ERROR     0x000040
#define RBU66_TJD_ERROR     0x000080
#define DCF77_TX_ABNL       0x000200
#define DCF77_A1_CEST       0x000400
#define DCF77_Z1_CEST       0x000800
#define DCF77_Z1_Z2_ERROR   0x001000
#define DCF77_Z2_CET        0x002000
#define DCF77_A2_LEAP_SEC   0x004000
#define MSF60_SMTM_WARN     0x008000
#define MSF60_SMTM_EFFC     0x010000
#define MSF60_SMTM_ERROR    0x020000

//------------------------------------------------------------------------

// time_signal.c
void Free_Time_Buffers(void);
void Receive_DCF77(Transceiver_t *TRx);
void Receive_ALL162(Transceiver_t *TRx);
void Receive_RBU66(Transceiver_t *TRx);
void Receive_MSF60(Transceiver_t *TRx);

//------------------------------------------------------------------------

#endif

