/*
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 2 of
 *  the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details:
 *
 *  http://www.gnu.org/copyleft/gpl.txt
 */

#include "interface.h"
#include "../common/common.h"
#include "../common/guest_utils.h"
#include "../common/hermes2_rc.h"
#include "../common/shared.h"
#include "../common/utils.h"
#include "../Hermes2/interface.h"
#include <gtk/gtk.h>
#include <stdlib.h>

//----------------------------------------------------------------------

#define TIME_GLADE_FILE "/.hermes2/time/time.glade"

#define TIME_WINDOW_IDS \
  "time_window", \
   NULL

//------------------------------------------------------------------------

GtkWidget  *time_window = NULL;
GtkBuilder *time_window_builder = NULL;

//------------------------------------------------------------------------

/* Time_Tx_Activate()
 *
 * Handles the on_qso_menu_item_activate() callback
 * for the Time Stations Menu Item
 */
  void
Time_Tx_Activate( void )
{
  // Open time display window if not already open
  if( time_window ) return;
  Indices.Time_TRx_Idx = Indices.TRx_Index;

  gchar time_glade[FILE_NAME_SIZE];
  Strlcpy( time_glade, getenv("HOME"), sizeof(time_glade) );
  Strlcat( time_glade, TIME_GLADE_FILE, sizeof(time_glade) );

  gchar *object_ids[] = { TIME_WINDOW_IDS };
  Gtk_Builder( &time_window_builder, time_glade, object_ids );
  time_window = Builder_Get_Object( time_window_builder, "time_window");

  /* Needed to destroy() the guest window on hermes2 quit */
  hermes2_gui.guest_window = time_window;

  Set_Window_Geometry( time_window,
      hermes2_rc.time_window_x,
      hermes2_rc.time_window_y,
      10, 10 );

  gtk_widget_show( time_window );
  GtkWidget *combo =
    Builder_Get_Object( time_window_builder, "time_station_combobox" );
  gtk_combo_box_set_active( GTK_COMBO_BOX(combo), 0 );

} // Time_Tx_Activate()

//----------------------------------------------------------------------

