/*
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 2 of
 *  the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details:
 *
 *  http://www.gnu.org/copyleft/gpl.txt
 */

#include "callbacks.h"
#include "display.h"
#include "interface.h"
#include "time_signal.h"
#include "../common/shared.h"
#include "../Hermes2/callback_func.h"
#include <gtk/gtk.h>
#include <stdlib.h>

//------------------------------------------------------------------------

// All callback functions of the Time Station decoder

  gboolean
on_time_window_delete(
    GtkWidget    *widget,
    GdkEvent     *event,
    gpointer      user_data )
{
  Close_Time_Display();
  return( FALSE );
}

//------------------------------------------------------------------------

  void
on_time_window_destroy(
    GObject     *object,
    gpointer    user_data )
{
  Free_Time_Buffers();
  time_window = NULL;
  hermes2_gui.guest_window = NULL;
}

//------------------------------------------------------------------------

  void
on_time_station_combobox_changed(
    GtkComboBox     *combobox,
    gpointer         user_data )
{
  Time_Station_Combobox_Changed( combobox );
}

//------------------------------------------------------------------------

  void
on_time_receive_togglebutton_toggled(
    GtkToggleButton *togglebutton,
    gpointer         user_data )
{
  const discovered_device_t *ddv = &Device[hermes2_rc.device_index];

  if( ddv->transmit_on )
    return;

  Time_Receive_Togglebutton_Toggled( togglebutton );
}

//------------------------------------------------------------------------

  void
on_time_quit_button_clicked(
    GtkButton    *button,
    gpointer      user_data )
{
  // Close time display window
  Close_Time_Display();
}

//------------------------------------------------------------------------

