/*
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 2 of
 *  the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details:
 *
 *  http://www.gnu.org/copyleft/gpl.txt
 */

#include "shared.h"
#include "common.h"
#include "../common/ifft.h"
#include "../common/guest_utils.h"
#include <gtk/gtk.h>
#include <stdint.h>
#include <stdlib.h>

// Runtime config data
sstv_rc_t sstv_rc;

// SSTV Modes parameters
sstv_mode_params_t sstv_mode_params[SSTV_NUM_MODES - 1] =
{
  // Mode Name  Mode Index Frame sec  Line sec Scan sec Wdth Hgt  VIS   Sync Pulse Separator Scale
  { "Martin-1",        M1, 114.29700, 0.44647, 0.14644, 320, 256, 0xAC, 0.0048620, 0.000572, 2 },
  { "Martin-2",        M2,  58.06400, 0.22681, 0.07322, 320, 256, 0x28, 0.0048620, 0.000572, 2 },
  { "Scottie-1",       S1, 109.63250, 0.42822, 0.13825, 320, 256, 0x3C, 0.0090000, 0.001500, 2 },
  { "Scottie-2",       S2,  71.09450, 0.27768, 0.08807, 320, 256, 0xB8, 0.0090000, 0.001500, 2 },
  { "Scottie-DX",     SDX, 268.89380, 1.05033, 0.34562, 320, 256, 0xCC, 0.0090000, 0.001500, 2 },
  { "PASOKON-3",       P3, 203.06420, 0.40940, 0.13334, 640, 496, 0x71, 0.0052080, 0.001042, 1 },
  { "PASOKON-5",       P5, 304.59600, 0.61411, 0.20001, 640, 496, 0x72, 0.0078230, 0.001563, 1 },
  { "PASOKON-7",       P7, 406.12800, 0.81881, 0.26668, 640, 496, 0xF3, 0.0104170, 0.002083, 1 },
  { "PD-50",         PD50,  49.68448, 0.38816, 0.09152, 320, 256, 0x5d, 0.0200000, 0.002080, 2 },
  { "PD-90",         PD90,  89.99500, 0.70309, 0.17025, 320, 256, 0x63, 0.0200000, 0.002080, 2 },
  { "PD-120",       PD120, 126.11150, 0.50851, 0.12161, 640, 496, 0x5F, 0.0200000, 0.002080, 1 },
  { "PD-160",       PD160, 160.89420, 0.80447, 0.19559, 512, 400, 0xE2, 0.0200000, 0.002080, 1 },
  { "PD-180",       PD180, 187.06450, 0.75429, 0.18305, 640, 496, 0x60, 0.0200000, 0.002080, 1 },
  { "PD-240",       PD240, 248.01700, 1.00007, 0.24449, 640, 496, 0xE1, 0.0200000, 0.002080, 1 },
  { "PD-290",       PD290, 288.70200, 0.93734, 0.22881, 800, 616, 0xDE, 0.0200000, 0.002080, 1 },
  { "SC2-180",    SC2_180, 182.03850, 0.71109, 0.23502, 320, 256, 0xB7, 0.0055225, 0.000500, 2 }
};

// SSTV program status
sstv_status_t sstv_status;

// Sstv image display data
sstv_rx_image_t sstv_rx_image;

// Sstv GUI data
sstv_gui_t sstv_gui;

// Pixbuffer for waterfall
pixbuffer_t sstv_wfall;

// Signal scope size
uint16_t
  sstv_scope_width,
  sstv_scope_height;

// IFFT data for spectrum display
ifft_data_t sstv_ifft_data;

// SSTV Image Decoder function pointer
void (* Sstv_Image_Decoder) (void) = NULL;

//------------------------------------------------------------------

