/*
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 3 of
 *  the License, or (at your option) any later version.

 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details:
 *
 *  http://www.gnu.org/copyleft/gpl.txt
 */

#include "operation.h"
#include "decode.h"
#include "detect.h"
#include "encode.h"
#include "shared.h"
#include "../common/common.h"
#include "../common/shared.h"
#include "../common/utils.h"
#include "../Hermes2/display.h"
#include <gtk/gtk.h>
#include <stdint.h>
#include <stdio.h>
#include <stdlib.h>

//------------------------------------------------------------------------

/* Sstv_Receive_Control()
 *
 * Central control function that directs Sstv decoding functions
 */
  void *
Sstv_Receive_Control( void *data )
{
  // Continues decoding images while enabled
  BOOLEAN ret = Sstv_Decode();

  // Stop decoding if decoder fails
  if( !ret ) sstv_status.sstv_action = SSTV_ACTION_STOP;

  // Stop operations
  if( sstv_status.sstv_action == SSTV_ACTION_STOP )
  {
    sstv_status.image_decoder_enable = False;
    sstv_status.new_period_detected  = False;
    sstv_status.detect_vis_leader    = False;
    sstv_status.detect_vis_mode      = False;

    Flag[GUEST_DEMOD_IQ_DATA]   = False;
    Flag[GUEST_RECEIVE_MODE]    = False;

    // Destroy digimode semaphore
    Init_Semaphore( &digimode_semaphore, False );
  } // switch( sstv_action )

  return( NULL );
} // Sstv_Receive_Control()

//------------------------------------------------------------------------

/* Sstv_Transmit_Control()
 *
 * Controls SSTV Image transmission
 */
  void *
Sstv_Transmit_Control( void *data )
{
  // Transmit Vertical Interval Signal (start of image)
  Encode_VIS();

  // Transmit the SSTV Image
  if( sstv_status.sstv_action == SSTV_ACTION_TRANSMIT )
  {
    if( !Encode_Image() )
      sstv_status.sstv_action = SSTV_ACTION_STOP;
  }

  // Last Transmit action - transmit FSKID
  if( sstv_status.sstv_action == SSTV_ACTION_TRANSMIT )
    Encode_FSKID();

  // Clear Transmit related flags
  Flag[GUEST_TRANSMIT_MODE]    = False;
  Flag[GUEST_TRANSMIT_MACRO]   = False;
  Flag[GUEST_TRANSMIT_ID]      = False;

  return( NULL );
} // Sstv_Transmit_Control()

//------------------------------------------------------------------------

