/*
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 3 of
 *  the License, or (at your option) any later version.

 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details:
 *
 *  http://www.gnu.org/copyleft/gpl.txt
 */

#ifndef SSTV_DISPLAY_H
#define SSTV_DISPLAY_H   1

#include "../common/common.h"
#include <cairo/cairo.h>
#include <gtk/gtk.h>
#include <stdint.h>

//----------------------------------------------------------------------

#define SSTV_WHITE_FREQ   2300 // Frequency of white (maximum) value of video
#define SSTV_BLACK_FREQ   1500 // Frequency of black (minimum) value of video

void Sstv_Spectrum_Size_Allocate(uint16_t width, uint16_t height);
void Sstv_Display_Waterfall(void);
void Sstv_Draw_Signal(cairo_t *cr);
void Sstv_Free_Display(void);
void Sstv_Display_Signal(uint8_t plot);
void Sstv_Set_TxRx_Labels(void);
BOOLEAN Sstv_Display_Stock_Image(const char *image_name);
void Resize_Image_Pixbuf(gint width, gint height, BOOLEAN reset);

//----------------------------------------------------------------------

#endif

