/*
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 3 of
 *  the License, or (at your option) any later version.

 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details:
 *
 *  http://www.gnu.org/copyleft/gpl.txt
 */

#ifndef SSTV_DETECT_H
#define SSTV_DETECT_H   1

#include "../common/common.h"
#include <stdint.h>

/*------------------------------------------------------------------*/

/* Circular buffer to store the detected
 * instantaneous frequency of FM SSTV signal */
#define FM_DISCRIM_BUF_SIZE    20971520
extern int16_t fm_discrim_buffer[FM_DISCRIM_BUF_SIZE];

// Index to new frequency entry into ring buffer
extern int32_t fm_discrim_buf_idx;

/*------------------------------------------------------------------*/

BOOLEAN FM_Discriminator(void);
void Tone_Detectors( int16_t signal_sample );
void VIS_Leader_Detect(void);
void VIS_Mode_Detect(void);
void Line_Sync_Detect(void);
void Process_Line_Sync(void);

#endif

