/*
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 2 of
 *  the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details:
 *
 *  http://www.gnu.org/copyleft/gpl.txt
 */

#ifndef SSTV_COMMON_H
#define SSTV_COMMON_H   1

enum _SSTV_MODES
{
  M1, M2,
  S1, S2, SDX,
  P3, P5, P7,
  PD50, PD90, PD120, PD160, PD180, PD240, PD290,
  SC2_180,
  AUTO,
  SSTV_NUM_MODES
};

#define DEFAULT_MODE     0xFF  // Default Mode is Martin M1
#define DEFAULT_LABEL   "Default (M1)"

#define SSTV_MODE_MENU_ITEMS \
  "Martin-1", \
  "Martin-2", \
  "Scottie-1", \
  "Scottie-2", \
  "Scottie-DX", \
  "Pasokon-3", \
  "Pasokon-5", \
  "Pasokon-7", \
  "PD-50", \
  "PD-90", \
  "PD-120", \
  "PD-160", \
  "PD-180", \
  "PD-240", \
  "PD-290", \
  "SC2-180", \
  "Auto"

// Sstv control flags
enum
{
  SSTV_ACTION_VIS_LEADER,  // Detect the SSTV VIS Leader sequence
  SSTV_ACTION_VIS_MODE,    // Detect the SSTV VIS Mode sequence
  SSTV_ACTION_SYNC_DETECT, // Detect the SSTV VIS Mode sequence
  SSTV_ACTION_DECODE,      // Decode the SSTV image
  SSTV_ACTION_TRANSMIT,    // Transmit an SSTV image
  SSTV_ACTION_STOP         // Stop operations
};

/* The setting for the BFO (Weaver Frequency) for SSTV is 4000Hz
 * This make the IQ stream's center frequency 2000Hz so that we
 * need this reference frequency to correct the FM discriminator */
#define IQ_STREAM_REF_FREQ   2000

// Used to calculate frequency error in detecting VIS Leader tones
#define VIS_1200HZ_REF   1200  // VIS 10ms Break tone
#define VIS_1900HZ_REF   1900  // VIS 300ms Leader tone
#define VIS_BIT1_FREQ    1100  // Frequency of VIS "1" pulse
#define VIS_BIT0_FREQ    1300  // Frequency of VIS "0" pulse

// Frequency of video line sync
#define SSTV_SYNC_FREQ   1200

// Number of Mode Data Bits, including Parity
#define NUM_MODE_BITS   8

// Low, High frequency of FSK ID stream tones (Hz)
#define FSKID_1900_HZ    1900  // 1-bit
#define FSKID_2100_HZ    2100  // 0-bit

// Height, in lines, of SSTV Title line on top of images
#define SSTV_TITLE_HGT    16

// Block flags for Sstv_New_Image()
#define NO_BLOCK False
#define BLOCK    True

#endif

